<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Atk_Categories_Controller extends CI_Controller {

    public function __construct(){
		parent::__construct();
		$this->load->model("Atk_Categories_model");
		$this->load->library('session');
	}

	public function index()
	{
		$data["atk"]=$this->Atk_Categories_model->getAll();
	    $this->load->view('Admin/head');
	    $this->load->view('Admin/Atk_Categories/view',$data);
        $this->load->view('Admin/Atk_Categories/add',$data);
		$this->load->view('Admin/footer');
	}

    public function input()
	{
		// $x['idKategori']=$this->kategori_model->autoId();
		$this->load->view('Admin/head');
		$this->load->view('Admin/Atk_Categories/add');
		$this->load->view('Admin/footer');
	}

	
    public function tambah(){
		$atk = $this->Atk_Categories_model;
		$result =$atk->save();
		if($result > 0) $this->sukses();
		else $this->gagal();	
		
	}

	function sukses(){
        $this->session->set_flashdata('pesan_success', 'Data Kategori ATK berhasil dibuat');
        redirect('Admin/ATK/Atk_Categories_Controller');
	}

	function gagal(){
        $this->session->set_flashdata('pesan_error', 'Data Kategori ATK gagal dibuat');
        redirect('Admin/ATK/Atk_Categories_Controller');
	}


    public function view_ubah($atk_categories_id) {
        $where = array('atk_categories_id' => $atk_categories_id);
        $data['atk'] = $this->Atk_Categories_model->view_update($where, 'atk_categories')->row(); // Use row() for a single object
        $this->load->view('Admin/head');
        $this->load->view('Admin/Atk_Categories/update', $data);
        $this->load->view('Admin/footer');
    }
    

    // Simpan Ubah ke Database
    public function update(){

		$post = $this->input->post();	
		$atk_categories_id 		= $this->input->post('atk_categories_id');
        $atk_categories_nama	= $this->input->post('atk_categories_nama');
   

        $data = array(
			'atk_categories_id'         => $atk_categories_id,
			'atk_categories_nama'       => $atk_categories_nama,
			'atk_categories_status'     => 1
        );

        $where = array(
            'atk_categories_id'       => $atk_categories_id
        );

        $this->Atk_Categories_model->update($where,$data,'atk_categories');
        $this->session->set_flashdata('pesan_success', 'Data Kategori ATK Berhasil diubah');
        redirect('Admin/ATK/Atk_Categories_Controller');
    }

	public function hapus($atk_categories_id){
		$data = array(
            'atk_categories_id'       => $atk_categories_id,
            'atk_categories_id_status'        => 0
        );

        $where = array(
            'atk_categories_id'       => $atk_categories_id
        );
        $this->Atk_Categories_model->update($where,$data,'atk_categories');
        $this->session->set_flashdata('pesan_success', 'Data Kategori ATK berhasil dihapus');
        redirect('Admin/ATK/Atk_Categories_Controller');
    }

    
}
?>