<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Atk_Pengambilan_Controller extends CI_Controller {

    public function __construct(){
		parent::__construct();
		$this->load->model("ATK_Pengambilan_model");
        $this->load->model("ATK_Categories_model");
        $this->load->model("ATK_Product_model");
        $this->load->model("Divisi_Categories_model");
		$this->load->library('session');
	}

	public function index()
	{
        $data["pengambilan"]=$this->ATK_Pengambilan_model->getAll();
		$data["product"]=$this->ATK_Product_model->getAll();
        $data["divisi"]=$this->Divisi_Categories_model->getAll();
        $data["kategori"]=$this->ATK_Categories_model->getAll();
        
	    $this->load->view('Admin/head');
	    $this->load->view('Admin/Atk_Pengambilan/view',$data);
        $this->load->view('Admin/Atk_Pengambilan/add',$data);
		$this->load->view('Admin/footer');
	}

    public function input()
	{
		// $x['idKategori']=$this->kategori_model->autoId();
        
		$this->load->view('Admin/head');
		$this->load->view('Admin/Atk_Pengambilan/add');
		$this->load->view('Admin/footer');
	}


    public function input_user()
	{
		// $x['idKategori']=$this->kategori_model->autoId();
        
		$this->load->view('Admin/head');
		$this->load->view('Admin/Atk_Pengambilan/add_user');
		$this->load->view('Admin/footer');
	}


    public function button()
	{
		// $x['idKategori']=$this->kategori_model->autoId();
        $data["pengambilan"]=$this->ATK_Pengambilan_model->getAll();
		$data["product"]=$this->ATK_Product_model->getAll();
        $data["divisi"]=$this->Divisi_Categories_model->getAll();
        $data["kategori"]=$this->ATK_Categories_model->getAll();

		$this->load->view('Admin/head_user');
        $this->load->view('Admin/Atk_Pengambilan/add_user',$data);
		$this->load->view('Admin/Atk_Pengambilan/button');
		$this->load->view('Admin/footer_user');
	}


    public function tambah()
    {
        $inventory = $this->ATK_Pengambilan_model;
        $result = $inventory->save();

        if ($result) {
            $this->sukses();
            // $this->sukses_user();

        } else {
            $this->session->set_flashdata('pesan_error', 'Stok tidak mencukupi.');
            redirect('Admin/ATK/Atk_Pengambilan_Controller');
        }
    }


    public function tambah_user()
    {
        $inventory = $this->ATK_Pengambilan_model;
        $result = $inventory->save();

        if ($result) {
            $this->sukses_user();

        } else {
            $this->session->set_flashdata('pesan_error', 'Stok tidak mencukupi.');
            redirect('Admin/ATK/Atk_Pengambilan_Controller/button');
        }
    }



    public function getProductsByCategory()
    {
        $category_id = $this->input->post('category_id'); // Ambil ID kategori dari AJAX
        $this->load->model("ATK_Product_model"); // Pastikan model dimuat

        // Ambil produk berdasarkan kategori
        $products = $this->db->get_where('atk_product', ['atk_product_categories' => $category_id])->result();

        // Kembalikan dalam format JSON untuk AJAX
        echo json_encode($products);
    }

	
    // public function tambah(){
	// 	$inventory = $this->ATK_Pengambilan_model;
	// 	$result =$inventory->save();
	// 	if($result > 0) $this->sukses();
	// 	else $this->gagal();	
		
	// }

	function sukses_user(){
        $this->session->set_flashdata('pesan_success', 'Data Pengambilan ATK berhasil dibuat');
        redirect('Admin/ATK/Atk_Pengambilan_Controller/button');
	}

    function sukses(){
        $this->session->set_flashdata('pesan_success', 'Data Pengambilan ATK berhasil dibuat');
        
        redirect('Admin/ATK/Atk_Pengambilan_Controller/');
	}


	function gagal(){
        $this->session->set_flashdata('pesan_error', 'Data Pengambilan Pengambilan tidak berhasil dibuat');
        redirect('Admin/ATK/Atk_Pengambilan_Controller');
	}



    public function view_ubah($atk_pengambilan_id) {
        $where = array('atk_pengambilan_id' => $atk_pengambilan_id);
        $data['pengambilan'] = $this->ATK_Pengambilan_model->view_update($where, 'atk_pengambilan')->row();
        $data["product"]=$this->ATK_Product_model->getAll();
        $data["divisi"]=$this->Divisi_Categories_model->getAll();

        $this->load->view('Admin/head');
        $this->load->view('Admin/Atk_Pengambilan/update', $data);
        $this->load->view('Admin/footer');
    }
    
    

    // Simpan Ubah ke Database
    public function update(){

        date_default_timezone_set("Asia/Jakarta");
        $tanggal = date("Y-m-d H:i:s");

		$post = $this->input->post();	
		$atk_pengambilan_id 		= $this->input->post('atk_pengambilan_id');
        $atk_pengambilan_peminjam = $this->input->post('atk_pengambilan_peminjam');
        $atk_pengambilan_divisi = $this->input->post('atk_pengambilan_divisi');
        $atk_pengambilan_product = $this->input->post('atk_pengambilan_product');
        $atk_pengambilan_jumlah = $this->input->post('atk_pengambilan_jumlah');
        
        // $atk_product_status = $this->input->post('atk_product_status');
        // $updated_at = $tanggal;

   

        $data = array(
			'atk_pengambilan_id'         => $atk_pengambilan_id,
			'atk_pengambilan_peminjam'       => $atk_pengambilan_peminjam,
            'atk_pengambilan_divisi'       => $atk_pengambilan_divisi,
            'atk_pengambilan_product'       => $atk_pengambilan_product,
            'atk_pengambilan_jumlah'       => $atk_pengambilan_jumlah,
            'atk_pengambilan_status'       => 1
           
        );

        $where = array(
            'atk_pengambilan_id'       => $atk_pengambilan_id
        );

        $this->ATK_Pengambilan_model->update($where,$data,'atk_pengambilan');
        $this->session->set_flashdata('pesan_success', 'Data Pengambilan ATK berhasil diubah');
        redirect('Admin/ATK/Atk_Pengambilan_Controller');
    }

	public function hapus($atk_pengambilan_id){
		$data = array(
            'atk_pengambilan_id'       => $atk_pengambilan_id,
            'atk_pengambilan_status'        => 0
        );

        $where = array(
            'atk_pengambilan_id'       => $atk_pengambilan_id
        );
        $this->ATK_Pengambilan_model->update($where,$data,'atk_pengambilan');
        $this->session->set_flashdata('pesan_success', 'Data Pengambilan ATK berhasil dihapus');
        redirect('Admin/ATK/Atk_Pengambilan_Controller');
    }

    
}
?>