<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Inventory_Controller extends CI_Controller {

    public function __construct(){
		parent::__construct();
		$this->load->model("Inventory_model");
        $this->load->model("Location_model");
        $this->load->model("Inventory_Types_model");
		$this->load->library('session');
	}

	public function index()
	{
		$data["inventory"]=$this->Inventory_model->getAll();
        $data["location"]=$this->Location_model->getAll();
        $data["type"]=$this->Inventory_Types_model->getAll();
	    $this->load->view('Admin/head');
	    $this->load->view('Admin/Inventory/view',$data);
        $this->load->view('Admin/Inventory/add',$data);
		$this->load->view('Admin/footer');
	}

    public function input()
	{
		// $x['idKategori']=$this->kategori_model->autoId();
		$this->load->view('Admin/head');
		$this->load->view('Admin/Inventory/add');
		$this->load->view('Admin/footer');
	}

	
    public function tambah(){
		$inventory = $this->Inventory_model;
		$result =$inventory->save();
		if($result > 0) $this->sukses();
		else $this->gagal();	
		
	}

	function sukses(){
        $this->session->set_flashdata('pesan_success', 'Data Inventory hasil dibuat');
        redirect('Inventory_Controller');
	}

	function gagal(){
        $this->session->set_flashdata('pesan_error', 'Data Location berhasil dibuat');
        redirect('Inventory_Controller');
	}


    // public function view_ubah($inventory_id) {
    //     $where = array('inventory_id' => $inventory_id);
    //     $data['inventory'] = $this->Inventory_model->view_update($where, 'inventory')->row(); // Use row() for a single object
    //     $this->load->view('Admin/head');
    //     $this->load->view('Admin/Inventory/update', $data);
    //     $this->load->view('Admin/footer');
    // }

    public function view_ubah($inventory_id) {
        $where = array('inventory_id' => $inventory_id);
        $data['inventory'] = $this->Inventory_model->view_update($where, 'inventory')->row();
        $data['locations'] = $this->Location_model->getAll(); // untuk lokasi
        $data['types'] = $this->Inventory_Types_model->getAll(); // untuk tipe
        $this->load->view('Admin/head');
        $this->load->view('Admin/Inventory/update', $data);
        $this->load->view('Admin/footer');
    }
    
    

    // Simpan Ubah ke Database
    public function update(){

        date_default_timezone_set("Asia/Jakarta");
        $tanggal = date("Y-m-d H:i:s");

		$post = $this->input->post();	
		$inventory_id 		= $this->input->post('inventory_id');
        $inventory_nama = $this->input->post('inventory_nama');
        $inventory_SN = $this->input->post('inventory_SN');
        $inventory_location_id = $this->input->post('inventory_location_id');
        $inventory_types_id = $this->input->post('inventory_types_id');
        $inventory_remarks = $this->input->post('inventory_remarks');
        $inventory_price = $this->input->post('inventory_price');
        $inventory_material = $this->input->post('inventory_material');
        $inventory_qty = $this->input->post('inventory_qty');
        $updated_by = $this->input->post('updated_by');
        $updated_at = $tanggal;

   

        $data = array(
			'inventory_id'         => $inventory_id,
			'inventory_nama'       => $inventory_nama,
            'inventory_SN'       => $inventory_SN,
            'inventory_location_id'       => $inventory_location_id,
            'inventory_types_id'       => $inventory_types_id,
            'inventory_remarks'       => $inventory_remarks,
            'inventory_price'       => $inventory_price,
            'inventory_material'       => $inventory_material,
            'inventory_qty'       => $inventory_qty,
            'updated_by'       => $updated_by,
            'updated_at'       => $updated_at,
			'inventory_status'     => 1
        );

        $where = array(
            'inventory_id'       => $inventory_id
        );

        $this->Inventory_model->update($where,$data,'inventory');
        $this->session->set_flashdata('pesan_success', 'Data Inventory berhasil diubah');
        redirect('Inventory_Controller');
    }

	public function hapus($inventory_id){
		$data = array(
            'inventory_id'       => $inventory_id,
            'inventory_status'        => 0
        );

        $where = array(
            'inventory_id'       => $inventory_id
        );
        $this->Location_model->update($where,$data,'inventory');
        $this->session->set_flashdata('pesan_success', 'Data Location berhasil dihapus');
        redirect('Inventory_Controller');
    }

    
}
?>