<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Divisi_Categories_Controller extends CI_Controller {

    public function __construct(){
		parent::__construct();
		$this->load->model("Divisi_Categories_model");
		$this->load->library('session');
	}

	public function index()
	{
		$data["divisi"]=$this->Divisi_Categories_model->getAll();
	    $this->load->view('Admin/head');
	    $this->load->view('Admin/Divisi_Categories/view',$data);
        $this->load->view('Admin/Divisi_Categories/add',$data);
		$this->load->view('Admin/footer');
	}

    public function input()
	{
		// $x['idKategori']=$this->kategori_model->autoId();
		$this->load->view('Admin/head');
		$this->load->view('Admin/Divisi_Categories/add');
		$this->load->view('Admin/footer');
	}

	
    public function tambah(){
		$divisi = $this->Divisi_Categories_model;
		$result =$divisi->save();
		if($result > 0) $this->sukses();
		else $this->gagal();	
		
	}

	function sukses(){
        $this->session->set_flashdata('pesan_success', 'Data divisi berhasil dibuat');
        redirect('Admin/Option/Divisi_Categories_Controller');
	}

	function gagal(){
        $this->session->set_flashdata('pesan_error', 'Data divisi gagal dibuat');
        redirect('Admin/Option/Divisi_Categories_Controller');
	}


    public function view_ubah($divisi_categories_id) {
        $where = array('divisi_categories_id' => $divisi_categories_id);
        $data['divisi'] = $this->Divisi_Categories_model->view_update($where, 'divisi_categories')->row(); // Use row() for a single object
        $this->load->view('Admin/head');
        $this->load->view('Admin/Divisi_Categories/update', $data);
        $this->load->view('Admin/footer');
    }
    

    // Simpan Ubah ke Database
    public function update(){

		$post = $this->input->post();	
		$divisi_categories_id 		= $this->input->post('divisi_categories_id');
        $divisi_categories_nama	= $this->input->post('divisi_categories_nama');
   

        $data = array(
			'divisi_categories_id'         => $divisi_categories_id,
			'divisi_categories_nama'       => $divisi_categories_nama,
			'divisi_categories_status'     => 1
        );

        $where = array(
            'divisi_categories_id'       => $divisi_categories_id
        );

        $this->Divisi_Categories_model->update($where,$data,'divisi_categorie');
        $this->session->set_flashdata('pesan_success', 'Data divisi Berhasil diubah');
        redirect('Admin/Option/Divisi_Categories_Controller');
    }

	public function hapus($divisi_categories_id){
		$data = array(
            'divisi_categories_id'       => $divisi_categories_id,
            'divisi_categories_status'        => 0
        );

        $where = array(
            'divisi_categories_id'       => $divisi_categories_id
        );
        $this->Divisi_Categories_model->update($where,$data,'divisi_categories');
        $this->session->set_flashdata('pesan_success', 'Data divisi berhasil dihapus');
        redirect('Admin/Option/Divisi_Categories_Controller');
    }

    
}
?>