<?php defined('BASEPATH') OR exit('No direct script access allowed');

class ATK_Product_model extends CI_Model
{
    private $_table = "atk_product";


    // public function getAll() {
    //     $this->db->select('atk_product.*, inventory_location.inventory_location_nama, inventory_types.inventory_types_nama, brand_categories.brand_categories_nama,
    //     atk_categories.atk_categories_nama, uom_categories.uom_categories_nama');
    //     $this->db->from('atk_product');
    //     $this->db->join('inventory_location', 'atk_product.atk_product_location = inventory_location.inventory_location_id', 'left');
    //     $this->db->join('inventory_types', 'atk_product.atk_product_inventory_types = inventory_types.inventory_types_id', 'left');
    //     $this->db->join('brand_categories', 'atk_product.atk_product_brand = brand_categories.brand_categories_id', 'left');
    //     $this->db->join('atk_categories', 'atk_product.atk_product_categories = atk_categories.atk_categories_id', 'left');
    //     $this->db->join('uom_categories', 'atk_product.atk_product_uom = uom_categories.uom_categories_id', 'left');
    //     $this->db->where('atk_product.atk_product_inventory_types', 9); // Kondisi 1
    //     $this->db->where('atk_product.atk_product_status', 1); // Kondisi 2
    //     $query = $this->db->get();
    //     return $query->result();
    // }

    public function getAll($filter_kategori = null, $filter_lokasi = null) {
        $this->db->select('atk_product.*, inventory_location.inventory_location_nama, inventory_types.inventory_types_nama, brand_categories.brand_categories_nama,
        atk_categories.atk_categories_nama, uom_categories.uom_categories_nama');
        $this->db->from('atk_product');
        $this->db->join('inventory_location', 'atk_product.atk_product_location = inventory_location.inventory_location_id', 'left');
        $this->db->join('inventory_types', 'atk_product.atk_product_inventory_types = inventory_types.inventory_types_id', 'left');
        $this->db->join('brand_categories', 'atk_product.atk_product_brand = brand_categories.brand_categories_id', 'left');
        $this->db->join('atk_categories', 'atk_product.atk_product_categories = atk_categories.atk_categories_id', 'left');
        $this->db->join('uom_categories', 'atk_product.atk_product_uom = uom_categories.uom_categories_id', 'left');
        
        // Kondisi default
        $this->db->where('atk_product.atk_product_inventory_types', 9); // Kondisi 1
        $this->db->where('atk_product.atk_product_status', 1); // Kondisi 2
    
        // Tambahkan filter kategori jika ada
        if ($filter_kategori) {
            $this->db->where('atk_product.atk_product_categories', $filter_kategori);
        }

        if ($filter_lokasi) {
            $this->db->where('atk_product.atk_product_location', $filter_lokasi);
        }
    
        $query = $this->db->get();
        return $query->result();
    }

    public function getFilteredProducts($kategoriFilter, $locationFilter)
    {
        // Mulai kueri dasar
        $this->db->select('atk_product.*, inventory_location.inventory_location_nama, brand_categories.brand_categories_nama, atk_categories.atk_categories_nama, uom_categories.uom_categories_nama');
        $this->db->from('atk_product');
        $this->db->join('inventory_location', 'atk_product.atk_product_location = inventory_location.inventory_location_id', 'left');
        $this->db->join('brand_categories', 'atk_product.atk_product_brand = brand_categories.brand_categories_id', 'left');
        $this->db->join('atk_categories', 'atk_product.atk_product_categories = atk_categories.atk_categories_id', 'left');
        $this->db->join('uom_categories', 'atk_product.atk_product_uom = uom_categories.uom_categories_id', 'left');
        $this->db->where('atk_product.atk_product_inventory_types', 9); // Kondisi 1
        $this->db->where('atk_product.atk_product_status', 1); // Kondisi 2
        
        // Filter berdasarkan kategori jika ada
        if (!empty($kategoriFilter)) {
            $this->db->where('atk_product.atk_product_categories', $kategoriFilter);
        }

        // Filter berdasarkan lokasi jika ada
        if (!empty($locationFilter)) {
            $this->db->where('atk_product.atk_product_location', $locationFilter);
        }

        $query = $this->db->get();
        return $query->result();
    }

    
   
    // public function getAll() {
    //     $this->db->select('atk_product.*, inventory_location.inventory_location_nama, inventory_types.inventory_types_nama, brand_categories.brand_categories_nama,
    //     atk_categories.atk_categories_nama, uom_categories.uom_categories_nama');
    //     $this->db->from('atk_product');
    //     $this->db->join('inventory_location', 'atk_product.atk_product_location = inventory_location.inventory_location_id', 'left');
    //     $this->db->join('inventory_types', 'atk_product.atk_product_inventory_types = inventory_types.inventory_types_id', 'left');
    //     $this->db->join('brand_categories', 'atk_product.atk_product_brand = brand_categories.brand_categories_id', 'left');
    //     $this->db->join('atk_categories', 'atk_product.atk_product_categories = atk_categories.atk_categories_id', 'left');
    //     $this->db->join('uom_categories', 'atk_product.atk_product_uom = uom_categories.uom_categories_id', 'left');
    //     $query = $this->db->get();
    //     return $query->result();
    // }
    

    public function jumlah_inventory()
    {
        $query =  $this->db->query(" SELECT COUNT(inventory_id) AS JumlahInventory FROM inventory where inventory_status = '1'");
        return $query->result();
      
    }
   
  
    public function save()
    {
        date_default_timezone_set("Asia/Jakarta");
        $tanggal = date("Y-m-d H:i:s");

        $post = $this->input->post();
        // $this->crew_id = $post["crew_id"];
        $this->atk_product_nama = $post["atk_product_nama"];
        $this->atk_product_stok = $post["atk_product_stok"];
        $this->atk_product_uom = $post["atk_product_uom"];
        // $this->atk_product_inventory_types = $post["atk_product_inventory_types"];
        $this->atk_product_inventory_types = "9";

        $this->atk_product_categories = $post["atk_product_categories"];
        $this->atk_product_brand = $post["atk_product_brand"];
        $this->atk_product_location = $post["atk_product_location"];
        $this->atk_product_notes = $post["atk_product_notes"];
        $this->atk_product_status = "1";
        $this->created_at =  $tanggal;
        $this->created_by = $post["created_by"];  
        return $this->db->insert($this->_table, $this);
    }
    public function view_update($where, $table){
        return $this->db->get_where($table, $where);
    }

    public function update($where, $data, $table){
        $this->db->where($where);
        $this->db->update($table, $data);
    }

    public function delete($where, $table){
        $this->db->where($where);
        $this->db->delete($table);
    }
}
