<!-- Modal Form untuk Tambah Inventory -->
<div class="modal fade" id="InventoryModal1" tabindex="-1" aria-labelledby="InventoryModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <!-- Modal Header with custom styling -->
            <div class="modal-header bg-primary text-white">
                <h5 class="modal-title" id="InventoryModalLabel"><i class="fas fa-user-plus"></i>Form Pengambilan ATK</h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
            </div>
            
            <!-- Modal Body with improved form styling -->
            <div class="modal-body">
                <form action="<?php echo site_url('Admin/ATK/Atk_Pengambilan_Controller/tambah_user'); ?>" method="post">
                    <!-- <input type="hidden" name="created_by" value="<?php echo $this->session->userdata('user_id'); ?>"> -->



                    <div class="mb-4">
                        <label for="atk_pengambilan_peminjam" class="form-label">Nama Lengkap</label>
                        <div class="input-group">
                            <span class="input-group-text"><i class="fas fa-building"></i></span>
                            <input type="text" class="form-control" id="atk_pengambilan_peminjam" name="atk_pengambilan_peminjam" placeholder="Masukkan nama Lengkap" value="<?= set_value('atk_product_nama') ?>" >
                        </div>
                    </div>


                    <div class="mb-4">
                        <label for="atk_pengambilan_divisi" class="form-label">Asal Divisi</label>
                        <div class="input-group">
                            <span class="input-group-text"><i class="fas fa-building"></i></span>
                            <select class="form-control" id="atk_pengambilan_divisi" name="atk_pengambilan_divisi" >
                                <option value="">-- Pilih Divisi --</option>
                                <?php foreach ($divisi as $inventory): ?>
                                    <option value="<?= $inventory->divisi_categories_id ; ?>" <?= set_select('divisi_categories_id  ', $inventory->divisi_categories_id ); ?>>
                                        <?= $inventory->divisi_categories_nama; ?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                    </div>


                    
                    <div class="mb-4">
                        <label for="atk_product_categories" class="form-label">Kategori ATK</label>
                        <div class="input-group">
                            <span class="input-group-text"><i class="fas fa-tags"></i></span>
                            <select class="form-control" id="atk_product_categories" name="atk_product_categories" onchange="getProducts()" required>
                                <option value="">-- Pilih Kategori --</option>
                                <?php foreach ($kategori as $inventory): ?>
                                    <option value="<?= $inventory->atk_categories_id; ?>">
                                        <?= $inventory->atk_categories_nama; ?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                    </div>

                    <div class="mb-4">
                        <label for="atk_product_id" class="form-label">Nama ATK</label>
                        <div class="input-group">
                            <span class="input-group-text"><i class="fas fa-box"></i></span>
                            <select class="form-control" id="atk_product_id" name="atk_pengambilan_product" onchange="getStock()" required>
                                <option value="">-- Pilih Produk --</option>
                            </select>
                        </div>
                        <small id="stokTersedia" class="text-muted"></small>
                    </div>

                    <div class="mb-4">
                        <label for="atk_pengambilan_jumlah" class="form-label">Jumlah yang diambil</label>
                        <div class="input-group">
                            <span class="input-group-text"><i class="fas fa-sort-numeric-up"></i></span>
                            <input type="number" class="form-control" id="atk_pengambilan_jumlah" name="atk_pengambilan_jumlah" placeholder="Masukkan Jumlah yang diambil" min="1" required oninput="validateStock()">
                        </div>
                        <small id="stokError" class="text-danger"></small>
                    </div>





                    <!-- Modal Footer with styled buttons -->
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal"><i class="fas fa-times"></i> Close</button>
                        <button type="submit" class="btn btn-primary"id="submitBtn"><i class="fas fa-save"></i> Save</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<!-- <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script> -->
<script>
var stokTersedia = 0;

function getProducts() {
    var categoryId = $("#atk_product_categories").val();
    $("#atk_product_id").html('<option value="">-- Pilih Produk --</option>');
    $("#stokTersedia").text("");

    if (categoryId !== "") {
        $.ajax({
            url: "<?= site_url('Admin/ATK/Atk_Pengambilan_Controller/getProductsByCategory') ?>",
            type: "POST",
            data: { category_id: categoryId },
            dataType: "json",
            success: function(response) {
                $.each(response, function(index, item) {
                    $("#atk_product_id").append('<option value="' + item.atk_product_id + '" data-stock="' + item.atk_product_stok + '">' + item.atk_product_nama + '</option>');
                });
            }
        });
    }
}

function getStock() {
    var selectedProduct = $("#atk_product_id option:selected");
    stokTersedia = parseInt(selectedProduct.data("stock")) || 0;
    $("#stokTersedia").text("Stok tersedia: " + stokTersedia);
    validateStock();
}

function validateStock() {
    var jumlahDiambil = parseInt($("#atk_pengambilan_jumlah").val()) || 0;
    if (jumlahDiambil > stokTersedia) {
        $("#stokError").text("Jumlah melebihi stok tersedia!");
        $("#submitBtn").prop("disabled", true);
    } else {
        $("#stokError").text("");
        $("#submitBtn").prop("disabled", false);
    }
}
</script>
