<!-- Main Container -->
<div class="container-fluid pt-4 px-4">
    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary">
                Data Divisi
                <span style="float: right">
                    <a href="<?php echo site_url('Admin/Option/Divisi_Categories_Controller/input'); ?>" class="btn btn-success btn-sm float-right" data-bs-toggle="modal" data-bs-target="#TypeModal">Tambah Data</a>
                </span>
            </h6>
        </div>

        <div class="card-body">
            <!-- Flash Messages -->
            <div id="flash" data-flash="<?= $this->session->flashdata('pesan_success'); ?>"></div>
            <?php if ($this->session->flashdata('pesan_error')): ?>
                <div class="alert alert-danger alert-dismissible bg-danger text-white border-0 fade show" role="alert">
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="Close"></button>
                    <?= $this->session->flashdata('pesan_error'); ?>
                </div>
            <?php endif; ?>

            <!-- Data Table -->
            <div class="table-responsive">
                <table class="table table-bordered table-hover table-striped" id="datatables">
                    <thead>
                        <tr>
                            <th class="text-center">No.</th>
                            <th class="text-center">Nama Divisi</th>
                            <th class="text-center">Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $i = 1; ?>
                        <?php foreach ($divisi as $k): ?>
                            <tr>
                                <td class="text-center"><?= $i++; ?></td>
                                <td><?= $k->divisi_categories_nama; ?></td>

                                <td class="text-center">
                                    <a href="<?= site_url('Admin/Option/Divisi_Categories_Controller/view_ubah/'.$k->divisi_categories_id); ?>" class="btn btn-warning btn-sm">
                                        <i class="fa fa-edit"></i>
                                    </a>
                                    <a href="<?= base_url('Admin/Option/Divisi_Categories_Controller/hapus/'.$k->divisi_categories_id); ?>" class="btn btn-danger btn-sm" id="tombol-hapus">
                                        <i class="fa fa-trash"></i>
                                    </a>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>  
        </div>
    </div>
</div>

<!-- Include Bootstrap and other required JS -->
<script>
    $(document).ready(function() {
        $('#datatables').DataTable();
    });
</script>
