<!-- Modal Form untuk Tambah Inventory -->
<div class="modal fade" id="InventoryModal" tabindex="-1" aria-labelledby="InventoryModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <!-- Modal Header with custom styling -->
            <div class="modal-header bg-primary text-white">
                <h5 class="modal-title" id="InventoryModalLabel"><i class="fas fa-user-plus"></i> Tambah Inventory</h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
            </div>
            
            <!-- Modal Body with improved form styling -->
            <div class="modal-body">
                <form action="<?php echo site_url('Inventory_Controller/tambah'); ?>" method="post">
                    <input type="hidden" name="created_by" value="<?php echo $this->session->userdata('user_id'); ?>">

                    <div class="mb-4">
                        <label for="inventory_nama" class="form-label">Nama Inventory</label>
                        <div class="input-group">
                            <span class="input-group-text"><i class="fas fa-building"></i></span>
                            <input type="text" class="form-control" id="inventory_nama" name="inventory_nama" placeholder="Masukkan nama Inventory" value="<?= set_value('inventory_nama') ?>" >
                        </div>
                    </div>

                    <div class="mb-4">
                        <label for="inventory_SN" class="form-label">Serial Number</label>
                        <div class="input-group">
                            <span class="input-group-text"><i class="fas fa-building"></i></span>
                            <input type="text" class="form-control" id="inventory_SN" name="inventory_SN" placeholder="Masukkan Serial Number" value="<?= set_value('inventory_SN') ?>" >
                        </div>
                    </div>


                    <div class="mb-4">
                        <label for="client_id" class="form-label">Location Inventory</label>
                        <div class="input-group">
                            <span class="input-group-text"><i class="fas fa-building"></i></span>
                            <select class="form-control" id="inventory_location_id" name="inventory_location_id" >
                                <option value="">-- Pilih Location --</option>
                                <?php foreach ($location as $inventory): ?>
                                    <option value="<?= $inventory->inventory_location_id; ?>" <?= set_select('inventory_location_id', $inventory->inventory_location_id); ?>>
                                        <?= $inventory->inventory_location_nama; ?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                    </div>

                    <div class="mb-4">
                        <label for="inventory_types_id" class="form-label">Type Inventory</label>
                        <div class="input-group">
                            <span class="input-group-text"><i class="fas fa-user"></i></span>
                            <select class="form-control" id="inventory_types_id" name="inventory_types_id" >
                                <option value="">-- Pilih Type --</option>
                                <?php foreach ($type as $type): ?>
                                    <option value="<?= $type->inventory_types_id; ?>" <?= set_select('inventory_types_id', $type->inventory_types_id); ?>>
                                        <?= $type->inventory_types_nama; ?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                    </div>

                    <div class="mb-4">
                        <label for="inventory_SN" class="form-label">Remarks</label>
                        <div class="input-group">
                            <span class="input-group-text"><i class="fas fa-building"></i></span>
                            <input type="text" class="form-control" id="inventory_remarks" name="inventory_remarks" placeholder="Masukkan Remarks" value="<?= set_value('inventory_remarks') ?>" >
                        </div>
                    </div>

                    <div class="mb-4">
                        <label for="inventory_price" class="form-label">Price</label>
                        <div class="input-group">
                            <span class="input-group-text"><i class="fas fa-building"></i></span>
                            <input type="text" class="form-control" id="inventory_price" name="inventory_price" placeholder="Masukkan Price" value="<?= set_value('inventory_price') ?>" >
                        </div>
                    </div>
                    <div class="mb-4">
                        <label for="inventory_material" class="form-label">Material</label>
                        <div class="input-group">
                            <span class="input-group-text"><i class="fas fa-building"></i></span>
                            <input type="text" class="form-control" id="inventory_material" name="inventory_material" placeholder="Masukkan Jenis Material" value="<?= set_value('inventory_material') ?>" >
                        </div>
                    </div>
                    <div class="mb-4">
                        <label for="inventory_qty" class="form-label">Quantity</label>
                        <div class="input-group">
                            <span class="input-group-text"><i class="fas fa-building"></i></span>
                            <input type="text" class="form-control" id="inventory_qty" name="inventory_qty" placeholder="Masukkan Quantity" value="<?= set_value('inventory_qty') ?>" >
                        </div>
                    </div>


                   

                    <!-- Modal Footer with styled buttons -->
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal"><i class="fas fa-times"></i> Close</button>
                        <button type="submit" class="btn btn-primary"><i class="fas fa-save"></i> Save</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
