<!-- Edit Type Form -->
<div class="container mt-4">
    <div class="card shadow">
        <div class="card-header bg-warning text-white">
            <h5 class="m-0">Edit Type</h5>
        </div>
        <div class="card-body">
            <form action="<?php echo site_url('Inventory_Controller/update'); ?>" method="post">
                <input type="hidden" name="inventory_id" value="<?= $inventory->inventory_id; ?>">
                <input type="hidden" name="updated_by" value="<?php echo $this->session->userdata('user_id'); ?>">

                <div class="mb-3">
                    <label for="inventory_nama" class="form-label">Nama Inventory</label>
                    <input type="text" class="form-control" id="inventory_nama" name="inventory_nama" 
                           value="<?= set_value('inventory_nama', $inventory->inventory_nama); ?>" 
                           placeholder="Masukkan nama Inventory" >
                </div>

                <div class="mb-3">
                    <label for="inventory_SN" class="form-label">Serial Number</label>
                    <input type="text" class="form-control" id="inventory_SN" name="inventory_SN" 
                           value="<?= set_value('inventory_SN', $inventory->inventory_SN); ?>" 
                           placeholder="Masukkan nama Serial Number" >
                </div>

                
                <div class="mb-3">
                    <label for="inventory_location" class="form-label">Location Inventory</label>
                    <select class="form-select" id="inventory_location_id" name="inventory_location_id" >
                        <option value="" disabled>Pilih Lokasi</option>
                        <?php foreach ($locations as $loc): ?>
                            <option value="<?= $loc->inventory_location_id; ?>" <?= set_select('inventory_location', $loc->inventory_location_id, $inventory->inventory_location_id == $loc->inventory_location_id); ?>>
                                <?= $loc->inventory_location_nama; ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>

                <div class="mb-3">
                    <label for="inventory_type" class="form-label">Inventory Type</label>
                    <select class="form-select" id="inventory_types_id" name="inventory_types_id" >
                        <option value="" disabled>Pilih Tipe</option>
                        <?php foreach ($types as $type): ?>
                            <option value="<?= $type->inventory_types_id; ?>" <?= set_select('inventory_types', $type->inventory_types_id, $inventory->inventory_types_id == $type->inventory_types_id); ?>>
                                <?= $type->inventory_types_nama; ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>


                <div class="mb-3">
                    <label for="inventory_remarks" class="form-label">Remarks</label>
                    <input type="text" class="form-control" id="inventory_remarks" name="inventory_remarks" 
                           value="<?= set_value('inventory_remarks', $inventory->inventory_remarks); ?>" 
                           placeholder="Masukkan Remarks" >
                </div>
                <div class="mb-3">
                    <label for="inventory_price" class="form-label">Price</label>
                    <input type="text" class="form-control" id="inventory_price" name="inventory_price" 
                           value="<?= set_value('inventory_price', $inventory->inventory_price); ?>" 
                           placeholder="Masukkan Price" >
                </div>
                <div class="mb-3">
                    <label for="inventory_material" class="form-label">Material</label>
                    <input type="text" class="form-control" id="inventory_material" name="inventory_material" 
                           value="<?= set_value('inventory_material', $inventory->inventory_material); ?>" 
                           placeholder="Masukkan nama Material" >
                </div>

                <div class="mb-3">
                    <label for="inventory_qty" class="form-label">Quantity</label>
                    <input type="text" class="form-control" id="inventory_qty" name="inventory_qty" 
                           value="<?= set_value('inventory_qty', $inventory->inventory_qty); ?>" 
                           placeholder="Masukkan Quantity" >
                </div>



                <div class="d-flex justify-content-end">
                    <button type="submit" class="btn btn-warning me-2">Update</button>
                    <a href="<?php echo site_url('Inventory_Controller/index'); ?>" class="btn btn-secondary">Cancel</a>
                </div>
            </form>
        </div>
    </div>
</div>
