<!-- Main Container -->
<div class="container-fluid pt-4 px-4">
    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary">
                Data Inventory
                <span style="float: right">
                    <a href="<?php echo site_url('Inventory_Controller/input'); ?>" class="btn btn-success btn-sm float-right" data-bs-toggle="modal" data-bs-target="#InventoryModal">Tambah Data</a>
                </span>
            </h6>
        </div>

        <div class="card-body">
            <!-- Flash Messages -->
            <div id="flash" data-flash="<?= $this->session->flashdata('pesan_success'); ?>"></div>
            <?php if ($this->session->flashdata('pesan_error')): ?>
                <div class="alert alert-danger alert-dismissible bg-danger text-white border-0 fade show" role="alert">
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="Close"></button>
                    <?= $this->session->flashdata('pesan_error'); ?>
                </div>
            <?php endif; ?>

            <!-- Data Table -->
            <div class="table-responsive">
                <table class="table table-bordered table-hover table-striped" id="datatables">
                    <thead>
                        <tr>
                            <th class="text-center">No.</th>
                            <th class="text-center">Nama Inventory</th>
                            <th class="text-center">Serial Number</th>
                            <th class="text-center">Location</th>
                            <th class="text-center">Type Inventory</th>
                             <th class="text-center">Remarks</th>
                             <th class="text-center">Price</th>
                             <th class="text-center">Material</th>
                            <th class="text-center">Quantity</th>
                            <th class="text-center">Action</th>
                        </tr>
                    </thead>
                    <tbody>
    <?php $i = 1; ?>
    <?php foreach ($inventory as $k): ?>
        <tr>
            <td class="text-center"><?= $i++; ?></td>
            <td><?= $k->inventory_nama; ?></td>
            <td><?= $k->inventory_SN; ?></td>
            <td><?= $k->inventory_location_nama; ?></td> <!-- Nama Location -->
            <td><?= $k->inventory_types_nama; ?></td> <!-- Nama Type Inventory -->
            <td><?= $k->inventory_remarks; ?></td>
            <td><?= $k->inventory_price; ?></td>
            <td><?= $k->inventory_material; ?></td>
            <td><?= $k->inventory_qty; ?></td>

            <td class="text-center">
                <a href="<?= site_url('Inventory_Controller/view_ubah/'.$k->inventory_id); ?>" class="btn btn-warning btn-sm">
                    <i class="fa fa-edit"></i>
                </a>
                <a href="<?= base_url('Inventory_Controller/hapus/'.$k->inventory_id); ?>" class="btn btn-danger btn-sm" id="tombol-hapus">
                    <i class="fa fa-trash"></i>
                </a>
            </td>
        </tr>
    <?php endforeach; ?>
</tbody>

                </table>
            </div>  
        </div>
    </div>
</div>

<!-- Include Bootstrap and other required JS -->
<script>
    $(document).ready(function() {
        $('#datatables').DataTable();
    });
</script>
