<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login - AsiaServ</title>

    <!-- Favicon -->
    <link href="<?= base_url('assets/img/favicon.ico'); ?>" rel="icon">

    <!-- Custom Styles -->
    <style>
        /* Reset dan Styling Global */
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

      /* Tambahkan latar belakang dengan gradien */
    body, html {
        font-family: 'Arial', sans-serif;
        height: 100%;
        margin: 0;
        background: linear-gradient(135deg, #17a2b8, #138f9c);
        color: #333;
    }

    .login-container {
        display: flex;
        flex-direction: column;
        justify-content: center;
        align-items: center;
        height: 100vh;
        padding: 20px;
        background: rgba(255, 255, 255, 0.8); /* Transparansi untuk efek lapisan */
        border-radius: 15px;
        box-shadow: 0 4px 20px rgba(0, 0, 0, 0.2);
    }


        /* Kartu Login */
        .login-card {
            background: white;
            padding: 30px;
            border-radius: 10px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.2);
            width: 100%;
            max-width: 400px;
            text-align: center;
        }

        .login-card h3 {
            margin-bottom: 20px;
            color: #333;
        }

        /* Input dan Form */
        .form-group {
            margin-bottom: 15px;
            text-align: left;
        }

        .form-group label {
            display: block;
            font-size: 14px;
            margin-bottom: 5px;
        }

        .form-group input {
            width: 100%;
            padding: 10px;
            font-size: 14px;
            border: 1px solid #ddd;
            border-radius: 5px;
        }

        /* Tombol Login */
        .login-button {
            width: 100%;
            padding: 10px;
            background: #17a2b8;
            color: white;
            font-size: 16px;
            font-weight: bold;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            transition: background 0.3s ease;
        }

        .login-button:hover {
            background: #138f9c;
        }

        /* Teks Footer */
        .footer-text {
            margin-top: 20px;
            font-size: 12px;
            color: #aaa;
        }
    </style>
</head>
<body>

<div class="login-container">
    <div class="login-card">
    <h3>Login Form</h3>
    <img src="<?= base_url('assets/img/asi.jpg'); ?>" alt="Logo" style="width: 300px; margin-bottom: 20px;">

        <form method="POST" action="<?= base_url('Auth/login/ceklogin') ?>" autocomplete="off">
            <div class="form-group">
                <label for="username">Account</label>
                <input type="text" id="username" name="username" placeholder="Enter your username">
                <?= form_error('username', '<small class="text-danger">', '</small>') ?>
            </div>
            <div class="form-group">
                <label for="password">Password</label>
                <input type="password" id="password" name="pass" placeholder="Enter your password">
                <?= form_error('pass', '<small class="text-danger">', '</small>') ?>
            </div>
            <button type="submit" class="login-button">Login</button>
        </form>
        <div class="footer-text">
            &copy; 2024 ASIASERV. All Rights Reserved
        </div>
    </div>
</div>

</body>
</html>
