<?php
defined('BASEPATH') OR exit('No direct script access allowed');

/*
| -------------------------------------------------------------------------
| URI ROUTING
| -------------------------------------------------------------------------
| This file lets you re-map URI requests to specific controller functions.
|
| Typically there is a one-to-one relationship between a URL string
| and its corresponding controller class/method. The segments in a
| URL normally follow this pattern:
|
|	example.com/class/method/id/
|
| In some instances, however, you may want to remap this relationship
| so that a different class/function is called than the one
| corresponding to the URL.
|
| Please see the user guide for complete details:
|
|	https://codeigniter.com/userguide3/general/routing.html
|
| -------------------------------------------------------------------------
| RESERVED ROUTES
| -------------------------------------------------------------------------
|
| There are three reserved routes:
|
|	$route['default_controller'] = 'welcome';
|
| This route indicates which controller class should be loaded if the
| URI contains no data. In the above example, the "welcome" class
| would be loaded.
|
|	$route['404_override'] = 'errors/page_missing';
|
| This route will tell the Router which controller/method to use if those
| provided in the URL cannot be matched to a valid route.
|
|	$route['translate_uri_dashes'] = FALSE;
|
| This is not exactly a route, but allows you to automatically route
| controller and method names that contain dashes. '-' isn't a valid
| class or method name character, so it requires translation.
| When you set this option to TRUE, it will replace ALL dashes in the
| controller and method URI segments.
|
| Examples:	my-controller/index	-> my_controller/index
|		my-controller/my-method	-> my_controller/my_method
*/
$route['default_controller'] = 'Auth/Login';
$route['404_override'] = '';
$route['translate_uri_dashes'] = FALSE;

$route['Login/ceklogin'] = 'Auth/Login/ceklogin';

// Routing untuk dashboard
$route['admin/dashboard'] = 'Admin/Admin_Dashboard_Controller/index';
$route['user/dashboard']  = 'User/User_Dashboard_Controller/index';

// Routing lain
$route['proses-barcode'] = 'Admin/ATK/Atk_Pengambilan_Controller/proses_barcode';
$route['pengambilan'] = 'Admin/ATK/Atk_Pengambilan_Controller/button';
$route['Admin/ATK/ATK_cart_controller/tambah_keranjang'] = 'Admin/ATK/ATK_cart_controller/tambah_keranjang';
$route['Admin/ATK/ATK_cart_controller/hapus_item/(:num)']= 'Admin/ATK/ATK_cart_controller/hapus_item/$1';
$route['Admin/ATK/ATK_cart_controller/checkout']         = 'Admin/ATK/ATK_cart_controller/checkout';
$route['Admin/ATK/Atk_Pengambilan_Controller/tambah'] = 'Admin/ATK/Atk_Pengambilan_Controller/tambah';
$route['Admin/ATK/Atk_Pengambilan_Controller/(:any)'] = 'Admin/ATK/Atk_Pengambilan_Controller/$1';

$route['admin/inventory'] = 'Admin/Inventory/Inventory_Controller/index';
$route['admin/inventory/produk/(:any)'] = 'Admin/Inventory/Inventory_Controller/produk/$1';
$route['admin/inventory/detail/(:num)'] = 'Admin/Inventory/Inventory_Controller/detail/$1';
$route['inventory-dashboard'] = 'Admin/Inventory/Inventory_Controller/dashboard';
$route['rekap/pdf'] = 'Admin/Admin_Dashboard_Controller/export_pdf';








