<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Inventory_Location_Controller extends CI_Controller {

    public function __construct(){
		parent::__construct();
		$this->load->model("Location_model");
		$this->load->library('session');
	}

	public function index()
	{
		$data["location"]=$this->Location_model->getAll();
	    $this->load->view('Admin/head');
	    $this->load->view('Admin/Location/view',$data);
        $this->load->view('Admin/Location/add',$data);
		$this->load->view('Admin/footer');
	}

    public function input()
	{
		// $x['idKategori']=$this->kategori_model->autoId();
		$this->load->view('Admin/head');
		$this->load->view('Admin/Location/add');
		$this->load->view('Admin/footer');
	}

	
    public function tambah(){
		$location = $this->Location_model;
		$result =$location->save();
		if($result > 0) $this->sukses();
		else $this->gagal();	
		
	}

	function sukses(){
        $this->session->set_flashdata('pesan_success', 'Data Location berhasil dibuat');
        redirect('Admin/Inventory/Inventory_Location_Controller');
	}

	function gagal(){
        $this->session->set_flashdata('pesan_error', 'Data Location berhasil dibuat');
        redirect('Admin/Inventory/Inventory_Location_Controller');
	}


    public function view_ubah($inventory_location_id) {
        $where = array('inventory_location_id' => $inventory_location_id);
        $data['location'] = $this->Location_model->view_update($where, 'inventory_location')->row(); // Use row() for a single object
        $this->load->view('Admin/head');
        $this->load->view('Admin/Location/update', $data);
        $this->load->view('Admin/footer');
    }
    

    // Simpan Ubah ke Database
    public function update(){

		$post = $this->input->post();	
		$Location_id 		= $this->input->post('inventory_location_id');
        $Location_nama	= $this->input->post('inventory_location_nama');
   

        $data = array(
			'inventory_location_id'         => $Location_id,
			'inventory_location_nama'       => $Location_nama,
			'inventory_location_status'     => 1
        );

        $where = array(
            'inventory_location_id'       => $Location_id
        );

        $this->Location_model->update($where,$data,'inventory_location');
        $this->session->set_flashdata('pesan_success', 'Data Location berhasil diubah');
        redirect('Admin/Inventory/Inventory_Location_Controller');
    }

	public function hapus($inventory_location_id){
    $where = array('inventory_location_id' => $inventory_location_id);
    
    // ✅ Ganti pemanggilan update() menjadi delete()
    $deleted_rows = $this->Location_model->delete($where, 'inventory_location');
    
    // Cek hasil operasi penghapusan
    if ($deleted_rows > 0) {
        $this->session->set_flashdata('pesan_success', 'Data Location berhasil dihapus secara permanen.');
    } else {
        $this->session->set_flashdata('pesan_error', 'Gagal menghapus data Location.');
    }
    
    redirect('Admin/Inventory/Inventory_Location_Controller');
}

    
}
?>