<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Brand_Categories_Controller extends CI_Controller {

    public function __construct(){
		parent::__construct();
		$this->load->model("Brand_Categories_model");
		$this->load->library('session');
	}

	public function index()
	{
		$data["brand"]=$this->Brand_Categories_model->getAll();
	    $this->load->view('Admin/head');
	    $this->load->view('Admin/Brand_Categories/view',$data);
        $this->load->view('Admin/Brand_Categories/add',$data);
		$this->load->view('Admin/footer');
	}

    public function input()
	{
		// $x['idKategori']=$this->kategori_model->autoId();
		$this->load->view('Admin/head');
		$this->load->view('Admin/Brand_Categories/add');
		$this->load->view('Admin/footer');
	}

	
    public function tambah(){
		$brand = $this->Brand_Categories_model;
		$result =$brand->save();
		if($result > 0) $this->sukses();
		else $this->gagal();	
		
	}

	function sukses(){
        $this->session->set_flashdata('pesan_success', 'Data Brand berhasil dibuat');
        redirect('Admin/Option/Brand_Categories_Controller');
	}

	function gagal(){
        $this->session->set_flashdata('pesan_error', 'Data Brand gagal dibuat');
        redirect('Admin/Option/Brand_Categories_Controller');
	}


    public function view_ubah($brand_categories_id) {
        $where = array('brand_categories_id' => $brand_categories_id);
        $data['brand'] = $this->Brand_Categories_model->view_update($where, 'brand_categories')->row(); // Use row() for a single object
        $this->load->view('Admin/head');
        $this->load->view('Admin/Brand_Categories/update', $data);
        $this->load->view('Admin/footer');
    }
    

    // Simpan Ubah ke Database
    public function update(){

		$post = $this->input->post();	
		$brand_categories_id 		= $this->input->post('brand_categories_id');
        $brand_categories_nama	= $this->input->post('brand_categories_nama');
   

        $data = array(
			'brand_categories_id'         => $brand_categories_id,
			'brand_categories_nama'       => $brand_categories_nama,
			'brand_categories_status'     => 1
        );

        $where = array(
            'brand_categories_id'       => $brand_categories_id
        );

        $this->Brand_Categories_model->update($where,$data,'brand_categories');
        $this->session->set_flashdata('pesan_success', 'Data Brand Berhasil diubah');
        redirect('Admin/Option/Brand_Categories_Controller');
    } 

	public function hapus($brand_categories_id){
    $data = array(
        'brand_categories_status' => 0
    );

    $where = array(
        'brand_categories_id' => $brand_categories_id
    );

    $this->Brand_Categories_model->update($where, $data, 'brand_categories');

    $this->session->set_flashdata('pesan_success', 'Data Brand berhasil dihapus');
    redirect('Admin/Option/Brand_Categories_Controller');
}


    
}
?>