<?php
require(APPPATH . '/third_party/fpdf184/fpdf.php');

class Pdf extends FPDF {
    function __construct($orientation = 'L', $unit = 'mm', $size = 'A4') {
        parent::__construct($orientation, $unit, $size); // ✅ Default Landscape
    }

    // Header kustom
    function Header() {
        $logoPath = FCPATH . 'assets/img/asiaserv-logo.png';

        if (file_exists($logoPath)) {
            $this->Image($logoPath, 10, 6, 30);
        } else {
            $this->SetFont('Arial','B',12);
            $this->Cell(0,10,'ASIASERV Asset Management',0,1,'C');
        }

        $this->SetFont('Arial','B',14);
        $this->Cell(0,10,'',0,1,'C');
        $this->Ln(10);
    }

    function Footer() {
        $this->SetY(-15);
        $this->SetFont('Arial', 'I', 8);
        $this->Cell(0, 10, 'Halaman ' . $this->PageNo(), 0, 0, 'C');
    }
    
}
