<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Atk_Cart_Model extends CI_Model {

    public function insert_cart($data) {
        return $this->db->insert('atk_cart', $data);
    }

    public function get_cart($user_id) {
        return $this->db->get_where('atk_cart', ['user_id' => $user_id])->result();
    }

    

    public function checkout_cart($user_id) {
        $cart_items = $this->get_cart($user_id);

        foreach ($cart_items as $item) {
            $this->db->insert('atk_pengambilan', [
                'atk_pengambilan_peminjam' => $item->user_id,
                'atk_pengambilan_divisi'   => $item->divisi,
                'atk_pengambilan_product'  => $item->produk,
                'atk_pengambilan_jumlah'   => $item->jumlah,
                'atk_pengambilan_status'   => 1,
                'created_at'               => date('Y-m-d H:i:s')
            ]);
        }

        $this->clear_cart($user_id);
    }
    public function get_products_by_category($category_id)
{
    return $this->db->where('atk_categories_id', $category_id)
                    ->get('atk_product')
                    ->result();
}

 public function get_cart_items() {
        return $this->db->get('atk_cart')->result_array();
    }

    public function add_to_cart($data) {
        return $this->db->insert('atk_cart', $data);
    }

    public function clear_cart() {
        return $this->db->empty_table('atk_cart');
    }

}
