<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Inventory_Location_model extends CI_Model {
    
    private $table = "inventory_location";

    public function __construct() {
        parent::__construct();
    }

    // 1. Fungsi untuk mengambil semua data (dengan filter status 1)
    public function getAll() {
        // ✅ Hanya tampilkan lokasi yang statusnya 1 (aktif)
        $this->db->where('inventory_location_status', 1); 
        $this->db->order_by('inventory_location_nama', 'ASC');
        return $this->db->get($this->table)->result();
    }

    // 2. Fungsi untuk menyimpan data baru (dipanggil oleh Controller->tambah())
    public function save() {
        $data = array(
            'inventory_location_nama'   => $this->input->post('inventory_location_nama'),
            'inventory_location_status' => 1, // Status default aktif
            'created_at'                => date('Y-m-d H:i:s')
        );
        
        $this->db->insert($this->table, $data);
        return $this->db->affected_rows();
    }

    // 3. Fungsi untuk mengambil data berdasarkan WHERE (dipanggil oleh Controller->view_ubah())
    public function view_update($where, $table){
        return $this->db->get_where($table, $where);
    }
    
    // 4. Fungsi untuk mengubah data (dipanggil oleh Controller->update() dan Controller->hapus())
    public function update($where, $data, $table){
        $this->db->where($where);
        $this->db->update($table, $data);
        return $this->db->affected_rows(); // Mengembalikan jumlah baris yang diupdate
    }

    // 5. Fungsi untuk menghapus permanen (Hard Delete) - Pilihan alternatif jika status 0 tidak diinginkan
    public function delete($where, $table){
        $this->db->where($where);
        $this->db->delete($table);
        return $this->db->affected_rows(); 
    }
}