<div class="container-fluid pt-4 px-4">
    <div class="card shadow-lg border-0 mb-4">
        <div class="card-header bg-primary text-white d-flex align-items-center p-3">
            <i class="fas fa-user-plus fa-lg me-3"></i>
            <h5 class="m-0 fw-bold">Tambah Pengguna Baru (Add User)</h5>
        </div>

        <div class="card-body p-4">
            <?php if ($this->session->flashdata('pesan')): ?>
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    <?= $this->session->flashdata('pesan'); ?>
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            <?php endif; ?>
            
            <form action="<?php echo site_url('Admin/Akun/masteruser/tambah/')?>" method="post" autocomplete="off" enctype="multipart/form-data">
                <input class="form-control" name="id" value="" type="hidden">
                
                <div class="row">
                    <div class="col-lg-8 border-end"> 
                        <h6 class="mb-4 text-primary fw-bold">Informasi Akun & Pribadi</h6>

                        <div class="row g-3 mb-3">
                            <div class="col-md-6">
                                <label class="form-label fw-semibold">Nama Lengkap <span class="text-danger">*</span></label>
                                <div class="input-group">
                                    <span class="input-group-text"><i class="fas fa-signature"></i></span>
                                    <input type="text" class="form-control" name="nama" value="<?= set_value('nama') ?>" placeholder="Masukkan Nama Lengkap" required>
                                </div>
                                <?= form_error('nama', '<small class="text-danger">', '</small>')?> 
                            </div>
                            <div class="col-md-6">
                                <label for="role" class="form-label fw-semibold">Role / Jabatan <span class="text-danger">*</span></label>
                                <div class="input-group">
                                    <span class="input-group-text"><i class="fas fa-user-tag"></i></span>
                                    <select name="role" class="form-select" required>
                                        <option value="">-- Pilih Role --</option>
                                        <?php $roles = ['Admin', 'Manager','Super Admin', 'Workshop', 'User']; ?>
                                        <?php foreach ($roles as $r): ?>
                                            <option value="<?= $r ?>" <?= set_select('role', $r) ?>><?= $r ?></option>
                                        <?php endforeach; ?>
                                    </select>
                                </div>
                                <?= form_error('role', '<small class="text-danger">', '</small>')?> 
                            </div>
                        </div>

                        <div class="row g-3 mb-4"> 
                            <div class="col-md-6">
                                <label class="form-label fw-semibold">Username <span class="text-danger">*</span></label>
                                <div class="input-group">
                                    <span class="input-group-text"><i class="fas fa-user"></i></span>
                                    <input type="text" class="form-control" name="username" value="<?= set_value('username') ?>" placeholder="Username untuk Login" required>
                                </div>
                                <?= form_error('username', '<small class="text-danger">', '</small>')?> 
                            </div>
                            <div class="col-md-6">
                                <label class="form-label fw-semibold">Password <span class="text-danger">*</span></label>
                                <div class="input-group input-group-merge">
                                    <span class="input-group-text"><i class="fas fa-lock"></i></span>
                                    <input type="password" class="form-control" id="password_input" name="pass" value="<?= set_value('pass') ?>" 
                                           placeholder="Min. 7 Karakter (huruf/angka)" minlength="7" required>
                                    <button class="btn btn-outline-secondary" type="button" id="togglePassword">
                                        <i class="fas fa-eye-slash"></i>
                                    </button>
                                </div>
                                <small class="form-text text-muted">Password harus terdiri dari minimal **7** karakter.</small>
                                <?= form_error('pass', '<small class="text-danger d-block">', '</small>')?> 
                            </div>
                        </div>

                        <hr class="mb-4">
                        <h6 class="mb-4 text-primary fw-bold">Detail Kontak & Lainnya</h6>

                        <div class="row g-3 mb-4">
                            <div class="col-md-6">
                                <label class="form-label fw-semibold d-block">Jenis Kelamin <span class="text-danger">*</span></label>
                                <div class="mt-2 d-flex">
                                    <div class="form-check me-4">
                                        <input type="radio" name="jenis_kelamin" id="gender_L" value="L" class="form-check-input" <?= set_radio('jenis_kelamin', 'L') ?> required>
                                        <label class="form-check-label" for="gender_L"><i class="fas fa-mars me-1"></i> Pria</label>
                                    </div>
                                    <div class="form-check">
                                        <input type="radio" name="jenis_kelamin" id="gender_P" value="P" class="form-check-input" <?= set_radio('jenis_kelamin', 'P') ?> required>
                                        <label class="form-check-label" for="gender_P"><i class="fas fa-venus me-1"></i> Wanita</label>
                                    </div>
                                </div>
                                <?= form_error('jenis_kelamin', '<small class="text-danger">', '</small>')?> 
                            </div>
                            <div class="col-md-6">
                                <label class="control-label fw-semibold">Tanggal Lahir <span class="text-danger">*</span></label>
                                <div class="input-group">
                                    <span class="input-group-text"><i class="fas fa-calendar-alt"></i></span>
                                    <input id="tanggal_lahir" class="form-control" type="date" name="tanggal_lahir" value="<?= set_value('tanggal_lahir') ?>" required>
                                </div>
                                <?= form_error('tanggal_lahir', '<small class="text-danger">', '</small>')?> 
                            </div>
                        </div>

                        <div class="row g-3 mb-4">
                            <div class="col-md-6">
                                <label class="control-label fw-semibold">Jabatan (Title) <span class="text-danger">*</span></label>
                                <div class="input-group">
                                    <span class="input-group-text"><i class="fas fa-briefcase"></i></span>
                                    <input type="text" class="form-control" name="pekerjaan" value="<?= set_value('pekerjaan') ?>" placeholder="Contoh: Staff IT, Marketing" required>
                                </div>
                                <?= form_error('pekerjaan', '<small class="text-danger">', '</small>')?> 
                            </div>
                            <div class="col-md-6">
                                <label class="control-label fw-semibold">Email <span class="text-danger">*</span></label>
                                <div class="input-group">
                                    <span class="input-group-text"><i class="fas fa-envelope"></i></span>
                                    <input type="email" class="form-control" name="email" value="<?= set_value('email') ?>" placeholder="user@domain.com" required>
                                </div>
                                <?= form_error('email', '<small class="text-danger">', '</small>')?> 
                            </div>
                        </div>

                        <div class="form-group mb-3">
                            <label class="control-label fw-semibold">Foto Profil</label>
                            <input type="file" name="foto_profile" class="form-control" id="preview_gambar" onchange="bacaGambar(this)">
                            <small class="form-text text-muted">Maksimal ukuran file 2MB (jpg/png).</small>
                        </div>
                    </div>
                    
                    <div class="col-lg-4 text-center d-flex flex-column align-items-center justify-content-start pt-5">
                        <div class="card w-100">
                            <div class="card-header bg-light text-dark fw-bold">Preview Foto</div>
                            <div class="card-body p-3">
                                <img src="<?= base_url('assets/template/admin/images/app/avatar_default.svg')?>" id="gambar_load" class="img-fluid rounded-3" style="max-height: 200px; object-fit: cover;">
                            </div>
                        </div>
                        
                        <div class="d-flex justify-content-end w-100 mt-4">
                            <a href="<?php echo site_url('Admin/Akun/masteruser') ?>" class="btn btn-outline-secondary me-2">
                                <i class="fas fa-times me-1"></i> Batal
                            </a>
                            <button type="submit" class="btn btn-primary fw-bold">
                                <i class="fas fa-save me-1"></i> Simpan Pengguna
                            </button>
                        </div>
                    </div> 
                </div> 
            </form>
        </div>
    </div>
</div>

<script>
    // Script untuk preview gambar
    function bacaGambar(input){
        if(input.files && input.files[0]){
            var reader = new FileReader();
            reader.onload = function(e){
                $('#gambar_load').attr('src', e.target.result);
            }
            reader.readAsDataURL(input.files[0]);
        }
    }

    $("#preview_gambar").change(function(){
        bacaGambar(this);
    });

    // Script untuk memunculkan/menyembunyikan password
    document.getElementById('togglePassword').addEventListener('click', function (e) {
        const passwordInput = document.getElementById('password_input');
        const icon = this.querySelector('i');
        if (passwordInput.type === 'password') {
            passwordInput.type = 'text';
            icon.classList.remove('fa-eye-slash');
            icon.classList.add('fa-eye');
        } else {
            passwordInput.type = 'password';
            icon.classList.remove('fa-eye');
            icon.classList.add('fa-eye-slash');
        }
    });

    // Script validasi usia minimum (17 tahun)
    document.getElementById('tanggal_lahir').addEventListener('change', function() {
        var today = new Date();
        var minimumAge = 17;
        var inputDate = new Date(this.value);
        var age = (today.getFullYear() - inputDate.getFullYear());
        
        // Penyesuaian jika ultah belum tiba tahun ini
        if (today.getMonth() < inputDate.getMonth() || (today.getMonth() === inputDate.getMonth() && today.getDate() < inputDate.getDate())) {
            age--;
        }

        if (age < minimumAge) {
            alert('Tanggal lahir tidak valid. Pengguna harus berusia minimal ' + minimumAge + ' tahun.');
            this.value = '';
        }
    });   
</script>