<div class="main-content" id="panel">
    <div class="container-fluid mt-4">
        <?php foreach($user as $u): ?>

        <div class="card shadow-sm mb-4 border-0">
            <div class="card-header bg-light p-3 border-bottom d-flex justify-content-between align-items-center">
                <h4 class="m-0 fw-bold text-dark">
                    <i class="fas fa-user-circle me-2 text-primary"></i> Detail Akun Pengguna
                </h4>
                <a href="<?php echo base_url('Admin/Akun/masteruser') ?>" class="btn btn-sm btn-info">
                    <i class="fas fa-chevron-left me-1"></i> Kembali
                </a>
            </div>
        </div>
        
        <div class="row g-4">
            
            <div class="col-xl-4 col-lg-5 order-lg-2">
                <div class="card shadow-lg h-100">
                    <div class="card-body text-center p-4">
                        <?php
                            // Tentukan URL foto profil
                            $foto_url = (empty($u->foto_profile))
                                      ? base_url('assets/template/admin/images/app/avatar_default.svg')
                                      : base_url('assets/image/profile/'.$u->foto_profile);

                            // Logika Role Badge
                            $role_lower = strtolower($u->role);
                            $role_display = ucwords($u->role);
                            $badge_class = 'bg-secondary';
                            
                            if ($role_lower === 'admin') {
                                $badge_class = 'bg-danger';
                            } elseif ($role_lower === 'manager' || $role_lower === 'pc') {
                                $badge_class = 'bg-primary';
                            } elseif ($role_lower === 'user' || $role_lower === 'crew' || $role_lower === 'workshop') {
                                $badge_class = 'bg-success';
                            }
                        ?>
                        
                        <img src="<?= $foto_url ?>" 
                             alt="Foto Profil <?= $u->nama_user ?>"
                             class="img-fluid rounded-circle mb-3 shadow-sm"
                             style="width: 180px; height: 180px; object-fit: cover; border: 4px solid #f8f9fa;">
                        
                        <h4 class="mt-3 mb-1 fw-bold text-dark"><?= $u->nama_user ?></h4>
                        <p class="text-muted mb-3"><?= $u->pekerjaan ?></p>
                        
                        <span class="badge <?= $badge_class ?> py-2 px-3 fw-bold fs-6 mt-2"><?= $role_display ?></span>
                    </div>
                </div>
            </div>

            <div class="col-xl-8 col-lg-7 order-lg-1">
                <div class="card shadow-lg h-100">
                    <div class="card-header bg-white border-bottom">
                        <h5 class="m-0 fw-bold text-dark"><i class="fas fa-info-circle me-2 text-secondary"></i> Informasi Lengkap</h5>
                    </div>
                    <div class="card-body p-4">
                        <div class="row g-3">
                            
                            <div class="col-md-6">
                                <p class="text-muted mb-1 fw-semibold small">Nama Lengkap</p>
                                <div class="d-flex align-items-center">
                                    <i class="fas fa-signature text-primary me-2 fa-lg"></i>
                                    <span class="fw-bold text-dark"><?php echo $u->nama_user ?></span>
                                </div>
                            </div>
                            
                            <div class="col-md-6">
                                <p class="text-muted mb-1 fw-semibold small">Peran (Role)</p>
                                <div class="d-flex align-items-center">
                                    <i class="fas fa-user-tag text-primary me-2 fa-lg"></i>
                                    <span class="fw-bold text-dark">
                                        <?php 
                                            // Menggunakan logika badge yang sudah dibuat di atas
                                        ?>
                                        <span class="badge <?= $badge_class ?>"><?= $role_display ?></span>
                                    </span>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <p class="text-muted mb-1 fw-semibold small">Jenis Kelamin</p>
                                <div class="d-flex align-items-center">
                                    <?php 
                                        $gender_text = ($u->jenis_kelamin == 'L') ? 'Laki-Laki' : (($u->jenis_kelamin == 'P') ? 'Perempuan' : '-');
                                        $gender_icon = ($u->jenis_kelamin == 'L') ? 'fas fa-mars' : 'fas fa-venus';
                                    ?>
                                    <i class="<?= $gender_icon ?> text-primary me-2 fa-lg"></i>
                                    <span class="fw-bold text-dark"><?= $gender_text ?></span>
                                </div>
                            </div>
                            
                            <div class="col-md-6">
                                <p class="text-muted mb-1 fw-semibold small">Email</p>
                                <div class="d-flex align-items-center">
                                    <i class="fas fa-envelope text-primary me-2 fa-lg"></i>
                                    <span class="fw-bold text-dark"><?= $u->email ?></span>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <p class="text-muted mb-1 fw-semibold small">Pekerjaan/Jabatan</p>
                                <div class="d-flex align-items-center">
                                    <i class="fas fa-briefcase text-primary me-2 fa-lg"></i>
                                    <span class="fw-bold text-dark"><?= $u->pekerjaan ?></span>
                                </div>
                            </div>
                            
                            <div class="col-md-6">
                                <p class="text-muted mb-1 fw-semibold small">Tanggal Lahir</p>
                                <div class="d-flex align-items-center">
                                    <?php 
                                        $tgl_lahir_format = (empty($u->tgl_lahir) || $u->tgl_lahir == '0000-00-00') 
                                                            ? '-' 
                                                            : date('d F Y', strtotime($u->tgl_lahir));
                                    ?>
                                    <i class="fas fa-calendar-alt text-primary me-2 fa-lg"></i>
                                    <span class="fw-bold text-dark"><?= $tgl_lahir_format ?></span>
                                </div>
                            </div>
                            
                            <hr class="my-3 col-12">
                            
                            <div class="col-md-6">
                                <p class="text-muted mb-1 fw-semibold small">Username</p>
                                <div class="d-flex align-items-center">
                                    <i class="fas fa-user text-primary me-2 fa-lg"></i>
                                    <span class="fw-bold text-dark"><?= $u->username ?></span>
                                </div>
                            </div>
                            
                            <div class="col-md-6">
                                <p class="text-muted mb-1 fw-semibold small">Password</p>
                                <div class="d-flex align-items-center">
                                    <i class="fas fa-lock text-primary me-2 fa-lg"></i>
                                    <span class="fw-bold text-dark">
                                        ********* (Tersembunyi)
                                    </span>
                                </div>
                            </div>

                        </div>
                    </div>
                </div> 
            </div>
        </div>
        
        <?php endforeach; ?>
    </div>
</div>