<div class="container-fluid pt-4 px-4">
    <div class="row g-4 justify-content-center">
        <div class="col-lg-10">
            <div class="card shadow-lg border-0">
                <div class="card-header bg-primary text-white p-3">
                    <h5 class="m-0"><i class="fas fa-edit me-2"></i> Edit Data Akun Pengguna</h5>
                </div>
                <div class="card-body p-4">

                    <?php foreach($user as $u): ?>

                    <form role="form" action="<?php echo site_url('Admin/Akun/masteruser/updateAkun') ?>" method="post">
                        
                        <input type="hidden" name="id_akun" value="<?php echo $u->id_akun ?>"> 

                        <h6 class="mb-3 text-primary fw-bold"><i class="fas fa-user-circle me-1"></i> Data Personal</h6>
                        <div class="row">
                            
                            <div class="col-lg-6 mb-3">
                                <label class="form-label">Nama Lengkap<span class="text-danger">*</span></label>
                                <div class="input-group">
                                    <span class="input-group-text"><i class="fas fa-signature"></i></span>
                                    <input type="text" class="form-control" name="nama_user" value="<?php echo $u->nama_user ?>" required>
                                </div>
                                <?php echo form_error('nama_user', '<small class="text-danger mt-1">', '</small>')?> 
                            </div>

                            <div class="col-lg-6 mb-3">
                                <label class="form-label">Email<span class="text-danger">*</span></label>
                                <div class="input-group">
                                    <span class="input-group-text"><i class="fas fa-envelope"></i></span>
                                    <input type="email" class="form-control" name="email" value="<?php echo $u->email ?>" required>
                                </div>
                                <?php echo form_error('email', '<small class="text-danger mt-1">', '</small>')?>
                            </div>

                            <div class="col-lg-6 mb-3">
                                <label class="form-label">Jenis Kelamin<span class="text-danger">*</span></label>
                                <div class="d-flex mt-2">
                                    <div class="form-check me-4">
                                        <input type="radio" name="jenis_kelamin" value="L" id="jkl" 
                                               <?php if($u->jenis_kelamin=='L') echo 'checked'?> class="form-check-input" required>
                                        <label class="form-check-label" for="jkl"><i class="fas fa-mars text-info me-1"></i> Laki-Laki</label>
                                    </div>
                                    <div class="form-check">
                                        <input type="radio" name="jenis_kelamin" value="P" id="jkp" 
                                               <?php if($u->jenis_kelamin=='P') echo 'checked'?> class="form-check-input" required>
                                        <label class="form-check-label" for="jkp"><i class="fas fa-venus text-pink me-1"></i> Perempuan</label>
                                    </div>
                                </div>
                                <?php echo form_error('jenis_kelamin', '<small class="text-danger mt-1">', '</small>')?>
                            </div>

                            <div class="col-lg-6 mb-3">
                                <label class="form-label">Tanggal Lahir<span class="text-danger">*</span></label>
                                <div class="input-group">
                                    <span class="input-group-text"><i class="fas fa-calendar-alt"></i></span>
                                    <input class="form-control" id="tanggal_lahir" type="date" name="tanggal_lahir" value="<?php echo $u->tgl_lahir ?>" required>
                                </div>
                                <?php echo form_error('tanggal_lahir', '<small class="text-danger mt-1">', '</small>')?>
                            </div>

                            <div class="col-lg-6 mb-3">
                                <label class="form-label">Pekerjaan/Jabatan<span class="text-danger">*</span></label>
                                <div class="input-group">
                                    <span class="input-group-text"><i class="fas fa-briefcase"></i></span>
                                    <input type="text" class="form-control" name="pekerjaan" value="<?php echo $u->pekerjaan ?>" required>
                                </div>
                                <?php echo form_error('pekerjaan', '<small class="text-danger mt-1">', '</small>')?>
                            </div>
                            
                            <div class="col-lg-6 mb-3">
                                <label for="role" class="form-label">Peran (Role)<span class="text-danger">*</span></label>
                                <div class="input-group">
                                    <span class="input-group-text"><i class="fas fa-users-cog"></i></span>
                                    <select name="role" class="form-select" required>
                                        <option value="<?php echo $u->role ?>" selected hidden><?php echo $u->role ?> (Saat Ini)</option> 
                                        <option value="Admin">Admin</option>
                                        <option value="Manager">Manager</option>
                                        <option value="PC">PC</option>
                                        <option value="Workshop">Workshop</option>
                                        <option value="User">User</option>
                                    </select>
                                </div>
                                <?php echo form_error('role', '<small class="text-danger mt-1">', '</small>')?>
                            </div>
                        </div>

                        <hr class="my-4">

                        <h6 class="mb-3 text-primary fw-bold"><i class="fas fa-lock me-1"></i> Data Login (Kosongkan jika tidak ingin ganti password)</h6>
                        <div class="row">
                            
                            <div class="col-lg-6 mb-3">
                                <label class="form-label">Username<span class="text-danger">*</span></label>
                                <div class="input-group">
                                    <span class="input-group-text"><i class="fas fa-user"></i></span>
                                    <input type="text" class="form-control" name="username" value="<?php echo $u->username ?>" required>
                                </div>
                                <?php echo form_error('username', '<small class="text-danger mt-1">', '</small>')?>
                            </div>

                            <div class="col-lg-6 mb-3">
                                <label class="form-label">Password Baru</label>
                                <div class="input-group">
                                    <span class="input-group-text"><i class="fas fa-key"></i></span>
                                    <input type="password" class="form-control" name="password" id="password" placeholder="Isi jika ingin ganti password">
                                </div>
                                <small class="text-muted">Kosongkan jika tidak ingin mengubah password.</small>
                                <?php echo form_error('password', '<small class="text-danger mt-1">', '</small>')?>
                            </div>

                            <div class="col-lg-6 mb-3">
                                <label class="form-label">Ulangi Password Baru</label>
                                <div class="input-group">
                                    <span class="input-group-text"><i class="fas fa-redo-alt"></i></span>
                                    <input type="password" class="form-control" name="repass" id="repass" onkeyup="validate()" placeholder="Ulangi password baru di sini">
                                </div>
                                <span id="confirm-message" class="d-block mt-1"></span>
                            </div>
                        </div>

                        <div class="d-flex justify-content-end pt-3">
                            <button type="reset" onclick="myFunction()" class="btn btn-secondary me-2">
                                <i class="fas fa-times-circle me-1"></i> Batal / Kembali
                            </button>
                            <button type="submit" id="submit" class="btn btn-primary">
                                <i class="fas fa-save me-1"></i> Simpan Perubahan
                            </button>
                        </div>
                    </form>
                    
                    <?php endforeach; ?>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
    // FUNGSI KEMBALI
    function myFunction() {
        window.location.href="<?php echo site_url('Admin/Akun/masteruser') ?>";
    }

    // FUNGSI VALIDASI PASSWORD
    function validate(){
        var password = document.getElementById('password').value;
        var confirm_pass = document.getElementById('repass').value;
        var message = document.getElementById('confirm-message');
        var btnsubmit = document.getElementById("submit");

        // Jika password baru kosong, tidak perlu cek kesamaan, dan tombol submit tetap aktif
        if(password === "") {
             message.innerHTML = "";
             btnsubmit.removeAttribute("disabled");
             return;
        }

        var good_color = "#198754"; // Green for success
        var bad_color = "#dc3545"; // Red for error

        if(password === confirm_pass){
            message.style.color = good_color;
            message.innerHTML = "Kata sandi **sesuai!**";
            btnsubmit.removeAttribute("disabled");
        } else {
            message.style.color = bad_color;
            message.innerHTML = "Kata sandi **tidak sesuai!**";
            btnsubmit.setAttribute( "disabled", "disabled");
        }
    }
    
    // FUNGSI VALIDASI USIA MINIMUM (17 Tahun)
    document.getElementById('tanggal_lahir').addEventListener('change', function() {
        var today = new Date();
        var minimumAge = 17;
        var inputDate = new Date(this.value);
        var age = today.getFullYear() - inputDate.getFullYear();
        var m = today.getMonth() - inputDate.getMonth();
        if (m < 0 || (m === 0 && today.getDate() < inputDate.getDate())) {
            age--;
        }

        if (age < minimumAge) {
            alert('Umur minimal adalah 17 tahun.');
            this.value = '';
        }
    }); 
    
    // CATATAN: Fungsi bacaGambar() dan preview_gambar tidak disertakan karena input file dikomentari.
    // Jika Anda ingin mengaktifkan upload foto profil, aktifkan input file dan tambahkan script ini.
</script>