<style>
/* * Ensures all table content is centered (vertical & horizontal) 
 * Made more specific to avoid interference from other global styles
 */
#datatables th, 
#datatables td {
    text-align: center;      /* horizontal center */
    vertical-align: middle;  /* vertical center */
}

/* Retain Notes column left-aligned for readability */
#datatables td:nth-child(8) { 
    /* This targets the 8th column, which is 'Notes' in the <td> body */
    text-align: left;
}
</style>

<div class="container-fluid pt-4 px-4">
    <div class="card shadow-lg border-0 mb-4">
        
        <div class="card-header bg-primary text-white py-4 d-flex justify-content-between align-items-center">
            <h5 class="m-0 fw-bold">
                <i class="fas fa-box-open me-2"></i> Stationery Product Master (ATK)
            </h5>
            <div class="btn-group" role="group">
                <a href="<?php echo site_url('Admin/ATK/Atk_Product_Controller/input'); ?>" 
                   class="btn btn-warning fw-bold shadow-sm" 
                   data-bs-toggle="modal" 
                   data-bs-target="#InventoryModal" 
                   title="Add New Product">
                    <i class="fas fa-plus me-1"></i> Add Data
                </a> 
                <a id="exportExcelBtn" class="btn btn-success shadow-sm" title="Export to Excel">
                    <i class="fas fa-file-excel me-1"></i> Export Excel
                </a>
                <a id="exportPdfBtn" class="btn btn-danger shadow-sm" title="Export to PDF">
                    <i class="fas fa-file-pdf me-1"></i> Export PDF
                </a>
            </div>
        </div>

        <div class="card-body border-bottom bg-light p-4">
            <h6 class="text-primary mb-3"><i class="fas fa-filter me-2"></i> Data Filter</h6>
            <form action="<?php echo site_url('Admin/ATK/Atk_Product_Controller/index'); ?>" method="get">
                <div class="row g-3 align-items-end">
                    <div class="col-md-6 col-lg-4">
                        <label for="filterKategori" class="form-label text-muted fw-bold small">Filter by Category:</label>
                        <select class="form-select" id="filterKategori" name="filter_kategori" onchange="this.form.submit()">
                            <option value="">-- All Categories --</option>
                            <?php 
                                foreach ($kategori as $k) {
                                    $selected = ($filter_kategori == $k->atk_categories_id) ? 'selected' : '';
                                    echo "<option value='{$k->atk_categories_id}' {$selected}>{$k->atk_categories_nama}</option>";
                                }
                            ?>
                        </select>
                    </div>

                    <div class="col-md-6 col-lg-4">
                        <label for="filterLokasi" class="form-label text-muted fw-bold small">Filter by Location:</label>
                        <select class="form-select" id="filterLokasi" name="filter_lokasi" onchange="this.form.submit()">
                            <option value="">-- All Locations --</option>
                            <?php 
                                foreach ($location as $k) {
                                    $selected = ($filter_lokasi == $k->inventory_location_id) ? 'selected' : '';
                                    echo "<option value='{$k->inventory_location_id}' {$selected}>{$k->inventory_location_nama}</option>";
                                }
                            ?>
                        </select>
                    </div>
                </div>
            </form>
        </div>

        <div class="card-body">
            <div id="flash" data-flash="<?= $this->session->flashdata('pesan_success'); ?>"></div>
            
            <?php if ($this->session->flashdata('pesan_success')): ?>
                <div class="alert alert-success alert-dismissible fade show d-flex align-items-center" role="alert">
                    <i class="fas fa-check-circle me-2"></i>
                    <?= $this->session->flashdata('pesan_success'); ?>
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            <?php endif; ?>
            
            <?php if ($this->session->flashdata('pesan_error')): ?>
                <div class="alert alert-danger alert-dismissible fade show d-flex align-items-center" role="alert">
                    <i class="fas fa-times-circle me-2"></i>
                    <?= $this->session->flashdata('pesan_error'); ?>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            <?php endif; ?>

            <div class="table-responsive">
                <table class="table table-bordered table-striped table-hover align-middle" id="datatables" style="width:100%">
                    <thead class="table-dark">
                        <tr>
                            <th class="text-center">No.</th>
                            <th>Product Name</th>
                            <th>Brand</th>
                            <th>Category</th>
                            <th>Stock</th>
                            <th>Unit</th>
                            <th>Location</th>
                            <th>Notes</th>
                            <th>Last Update</th>
                            <th class="text-center">Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $i = 1; ?>
                        <?php foreach ($product as $k): 
                            // === LOW STOCK LOGIC ADDED HERE ===
                            $stok = (int)$k->atk_product_stok;
                            $stok_status_class = ($stok < 5) ? 'bg-danger text-white' : 'bg-info text-dark';
                        ?>
                            <tr>
                                <td class="text-center fw-medium"><?= $i++; ?></td>
                                <td class="text-start"><?= $k->atk_product_nama; ?></td>
                                <td><?= $k->brand_categories_nama; ?></td>
                                <td><?= $k->atk_categories_nama; ?></td>
                                <td><span class="badge <?= $stok_status_class; ?> fw-bold"><?= $stok; ?></span></td>
                                
                                <td><?= $k->uom_categories_nama; ?></td>
                                <td><?= $k->inventory_location_nama; ?></td>
                                
                                <td class="text-start"><?= $k->atk_product_notes; ?></td>
                                <td><?= date("d-m-Y H:i", strtotime($k->update_date)); ?></td>
                                <td class="text-center">
                                    <a href="<?= site_url('Admin/ATK/Atk_Product_Controller/view_ubah/'.$k->atk_product_id); ?>" 
                                       class="btn btn-warning btn-sm shadow-sm" title="Edit Data">
                                        <i class="fas fa-edit"></i>
                                    </a>
                                    <a href="<?= base_url('Admin/ATK/Atk_Product_Controller/hapus/'.$k->atk_product_id); ?>" 
                                       class="btn btn-danger btn-sm shadow-sm btn-delete" 
                                       id="tombol-hapus" title="Delete Data">
                                        <i class="fas fa-trash"></i>
                                    </a>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
<!-- DATATABLES CSS -->
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.4/css/dataTables.bootstrap5.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.3.6/css/buttons.bootstrap5.min.css">


<!-- JQUERY -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

<!-- DATATABLES CORE -->
<script src="https://cdn.datatables.net/1.13.4/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.13.4/js/dataTables.bootstrap5.min.js"></script>

<script src="https://cdn.datatables.net/buttons/2.3.6/js/dataTables.buttons.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.bootstrap5.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.html5.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.print.min.js"></script>


<!-- EXCEL SUPPORT -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>

<!-- PDF SUPPORT -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/pdfmake.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/vfs_fonts.js"></script>


<script>
$(document).ready(function() {

    // --- DataTables FIX + Export Buttons ---
   $('#datatables').DataTable({
    dom: 'Bfrtip',
    responsive: true,
    buttons: [
        { extend: 'copy', text: 'Copy' },
        { extend: 'excelHtml5', text: 'Export Excel' },
        { extend: 'pdfHtml5', text: 'Export PDF' },
        { extend: 'print', text: 'Print' }
    ],
    pagingType: "simple_numbers"
});


    // --- Custom Export Excel (mengarah ke Controller) ---
    $('#exportExcelBtn').on('click', function() {
        var filterKategori = $('select[name="filter_kategori"]').val();
        var filterLokasi = $('select[name="filter_lokasi"]').val();

        var url = "<?= site_url('Admin/ATK/Atk_Product_Controller/export_excel'); ?>";
        url += '?filter_kategori=' + encodeURIComponent(filterKategori);
        url += '&filter_lokasi=' + encodeURIComponent(filterLokasi);

        window.location.href = url;
    });

    // --- Custom Export PDF (mengarah ke Controller) ---
    $('#exportPdfBtn').on('click', function() {
        var filterKategori = $('select[name="filter_kategori"]').val();
        var filterLokasi = $('select[name="filter_lokasi"]').val();

        var url = "<?= site_url('Admin/ATK/Atk_Product_Controller/export_pdf'); ?>";
        url += '?filter_kategori=' + encodeURIComponent(filterKategori);
        url += '&filter_lokasi=' + encodeURIComponent(filterLokasi);

        window.location.href = url;
    });

});
</script>
