<div class="container-fluid pt-4 px-4">
    <div class="card shadow-lg border-0 mb-4">
        
        <div class="card-header bg-primary text-white py-4 d-flex justify-content-between align-items-center">
            <h5 class="m-0 fw-bold">
                <i class="fas fa-sitemap me-2"></i> Master Division
            </h5>
            <span style="float: right">
                <a href="<?php echo site_url('Admin/Option/Divisi_Categories_Controller/input'); ?>" 
                   class="btn btn-warning fw-bold shadow-sm" 
                   data-bs-toggle="modal" 
                   data-bs-target="#TypeModal">
                    <i class="fas fa-plus me-1"></i> Add Data
                </a>
            </span>
        </div>

        <div class="card-body">
            <div id="flash" data-flash="<?= $this->session->flashdata('pesan_success'); ?>"></div>
            
            <?php if ($this->session->flashdata('pesan_success')): ?>
                <div class="alert alert-success alert-dismissible fade show d-flex align-items-center" role="alert">
                    <i class="fas fa-check-circle me-2"></i>
                    <?= $this->session->flashdata('pesan_success'); ?>
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            <?php endif; ?>
            
            <?php if ($this->session->flashdata('pesan_error')): ?>
                <div class="alert alert-danger alert-dismissible fade show d-flex align-items-center" role="alert">
                    <i class="fas fa-times-circle me-2"></i>
                    <?= $this->session->flashdata('pesan_error'); ?>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            <?php endif; ?>

            <div class="table-responsive">
                <table class="table table-bordered table-striped table-hover align-middle" id="datatables" style="width:100%">
                    <thead class="table-dark">
                        <tr>
                            <th class="text-center" style="width: 5%;">No.</th>
                            <th>Division Name</th>
                            <th class="text-center" style="width: 15%;">Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $i = 1; ?>
                        <?php foreach ($divisi as $k): ?>
                            <tr>
                                <td class="text-center fw-medium"><?= $i++; ?></td>
                                
                                <td class="text-center"><?= $k->divisi_categories_nama; ?></td>

                                <td class="text-center">
                                    <a href="<?= site_url('Admin/Option/Divisi_Categories_Controller/view_ubah/'.$k->divisi_categories_id); ?>" 
                                       class="btn btn-warning btn-sm shadow-sm" title="Edit Data">
                                        <i class="fas fa-edit"></i> Edit
                                    </a>
                                    <a href="<?= base_url('Admin/Option/Divisi_Categories_Controller/hapus/'.$k->divisi_categories_id); ?>" 
                                       class="btn btn-danger btn-sm shadow-sm" 
                                       id="tombol-hapus" title="Delete Data">
                                        <i class="fas fa-trash"></i>
                                    </a>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div> 
        </div>
    </div>
</div>

<script>
    // Maintaining original JavaScript/jQuery for DataTables initialization
    $(document).ready(function() {
        $('#datatables').DataTable();
        
        // **NOTE:** Ensure the SweetAlert code for delete confirmation on '#tombol-hapus' 
        // is present in your main JavaScript file.
    });
</script>