<div class="container-fluid pt-4 px-4">
    <div class="card shadow mb-4">
        <div class="card-header d-flex justify-content-between align-items-center">
            <h5 class="m-0 text-primary">
                Detail Produk: <?= htmlspecialchars($produk[0]->atk_product_nama ?? 'Produk Tidak Ditemukan') ?>
            </h5>
            <a href="<?= site_url('Admin/Inventory/Inventory_Controller/dashboard') ?>" class="btn btn-sm btn-secondary">
                <i class="fa fa-arrow-left"></i> Kembali
            </a>

        </div>
        <div class="card-body">
            <?php if(!empty($produk)): ?>
                <div class="table-responsive">
                    <table class="table table-bordered table-hover text-center align-middle">
                        <thead class="table-light">
                            <tr>
                                <th>No</th>
                                <th>ATK Name</th>
                                <th>Brand</th>
                                <th>Category</th>
                                <th>Inventory</th>
                                <th>Unit</th>
                                <th>Location</th>
                                <th>Notes</th>
                               
                            </tr>
                        </thead>
                        <tbody>
                            <?php $no = 1; foreach($produk as $row): ?>
                                <tr>
                                    <td><?= $no++ ?></td>
                                    <td><?= htmlspecialchars($row->atk_product_nama) ?></td>
                                    <td><?= htmlspecialchars($row->brand_categories_nama) ?></td>
                                    <td><?= htmlspecialchars($row->atk_categories_nama) ?></td>
                                    <td>
        <?php if ($row->atk_product_stok < 5): ?>
            <span class="badge bg-danger">
                <?= htmlspecialchars($row->atk_product_stok) . ' ' . htmlspecialchars($row->uom_categories_nama) ?>
                (Stok Hampir Habis!)
            </span>
        <?php else: ?>
            <span class="badge bg-success">
                <?= htmlspecialchars($row->atk_product_stok) . ' ' . htmlspecialchars($row->uom_categories_nama) ?>
            </span>
        <?php endif; ?>
    </td>
                                    <td><?= htmlspecialchars($row->inventory_location_nama) ?></td>
                                    <td><?= htmlspecialchars($row->atk_product_notes) ?></td>
                                    <td>

                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            <?php else: ?>
                <div class="alert alert-warning text-center">Tidak ada data untuk produk ini.</div>
            <?php endif; ?>
        </div>
    </div>
</div>
