<div class="container-fluid pt-4 px-4">
    <div class="card shadow-lg border-0 rounded-3 mb-5">
        
        <div class="card-header bg-primary text-white py-3 d-flex justify-content-between align-items-center">
            <h5 class="mb-0 fw-bold">
                <i class="fa fa-chart-bar me-2"></i> Rekap Karyawan Pengambilan ATK
            </h5>
            <div class="d-flex gap-2">
                <a href="<?= site_url('Admin/Admin_Dashboard_Controller/export_excel?bulan='.$bulan.'&tahun='.$tahun) ?>" 
                   class="btn btn-success btn-sm fw-semibold shadow-sm text-white">
                    <i class="fa fa-file-excel me-1"></i> Export Excel
                </a>
                <a href="<?= site_url('Admin/Admin_Dashboard_Controller/export_pdf?bulan='.$bulan.'&tahun='.$tahun) ?>" 
                   class="btn btn-danger btn-sm fw-semibold shadow-sm text-white" target="_blank">
                    <i class="fa fa-file-pdf me-1"></i> Export PDF
                </a>
            </div>
        </div>
        
        <div class="card-body p-4">

            <form method="get" class="row g-3 mb-5 align-items-end p-2 border rounded-3 bg-light">
                <div class="col-md-4 col-lg-3">
                    <label for="filterBulan" class="form-label fw-semibold">Bulan</label>
                    <select name="bulan" id="filterBulan" class="form-select shadow-sm">
                        <option value="all" <?= ($bulan=='all')?'selected':'' ?>>Semua Bulan</option>
                        <?php 
                        $nama_bulan = [
                            1=>"Januari",2=>"Februari",3=>"Maret",4=>"April",5=>"Mei",6=>"Juni",
                            7=>"Juli",8=>"Agustus",9=>"September",10=>"Oktober",11=>"November",12=>"Desember"
                        ];
                        for ($i=1;$i<=12;$i++): ?>
                            <option value="<?= $i ?>" <?= ($bulan==$i)?'selected':'' ?>>
                                <?= $nama_bulan[$i] ?>
                            </option>
                        <?php endfor; ?>
                    </select>
                </div>
                <div class="col-md-4 col-lg-3">
                    <label for="filterTahun" class="form-label fw-semibold">Tahun</label>
                    <input type="number" name="tahun" id="filterTahun" class="form-control shadow-sm" value="<?= $tahun ?>" placeholder="Contoh: 2024">
                </div>
                <div class="col-md-4 col-lg-2">
                    <button type="submit" class="btn btn-primary w-100 shadow-sm fw-semibold">
                        <i class="fa fa-filter me-1"></i> Terapkan Filter
                    </button>
                </div>
            </form>


            <h4 class="mb-3 text-primary fw-bold border-bottom pb-2"><i class="fa fa-user-friends me-2"></i> Rekap Per Karyawan</h4>
            <div class="table-responsive mb-5">
                <table class="table table-bordered table-striped table-hover align-middle shadow-sm rounded-3 overflow-hidden">
                    <thead class="bg-primary text-white">
                        <tr class="text-center">
                            <th scope="col" class="py-2">No</th>
                            <th scope="col" class="py-2">Nama Peminjam</th>
                            <th scope="col" class="py-2">Divisi</th>
                            <th scope="col" class="py-2">Total Transaksi</th>
                            <th scope="col" class="py-2">Total Item</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php 
                        $total_transaksi = 0;
                        $total_item = 0;
                        if(!empty($rekap)): 
                            $no=1; 
                            foreach($rekap as $r): 
                                $total_transaksi += $r->total_transaksi;
                                $total_item += $r->total_item;
                        ?>
                            <tr>
                                <td class="text-center fw-medium"><?= $no++ ?></td>
                                <td class="text-start fw-semibold"><?= $r->atk_pengambilan_peminjam ?></td>
                                <td class="text-center"><?= $r->atk_pengambilan_divisi ?></td>
                                <td class="text-center text-primary fw-bold"><?= $r->total_transaksi ?></td>
                                <td class="text-center text-success fw-bold"><?= $r->total_item ?></td>
                            </tr>
                        <?php endforeach; ?>
                            <tr class="table-primary fw-bold text-center border-2 border-dark">
                                <td colspan="3" class="text-end pe-4">Total Keseluruhan Transaksi & Item</td>
                                <td><?= $total_transaksi ?></td>
                                <td><?= $total_item ?></td>
                            </tr>
                        <?php else: ?>
                            <tr>
                                <td colspan="5" class="text-center text-muted py-3">
                                    <i class="fa fa-info-circle me-1"></i> Belum ada data pengambilan ATK pada periode ini.
                                </td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>

            <h4 class="mb-3 text-success fw-bold border-bottom pb-2"><i class="fa fa-building me-2"></i> Rekap Per Divisi</h4>
            <div class="table-responsive">
                <table class="table table-bordered table-striped table-hover align-middle shadow-sm rounded-3 overflow-hidden">
                    <thead class="bg-success text-white">
                        <tr class="text-center">
                            <th scope="col" class="py-2">No</th>
                            <th scope="col" class="py-2">Divisi</th>
                            <th scope="col" class="py-2">Total Karyawan Unik</th>
                            <th scope="col" class="py-2">Total Transaksi</th>
                            <th scope="col" class="py-2">Total Item</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php 
                        $total_karyawan_div = 0;
                        $total_transaksi_div = 0;
                        $total_item_div = 0;
                        if(!empty($rekap_divisi)): 
                            $no=1; 
                            foreach($rekap_divisi as $d): 
                                $total_karyawan_div += $d->total_karyawan;
                                $total_transaksi_div += $d->total_transaksi;
                                $total_item_div += $d->total_item;
                        ?>
                            <tr>
                                <td class="text-center fw-medium"><?= $no++ ?></td>
                                <td class="text-start fw-semibold"><?= $d->atk_pengambilan_divisi ?></td>
                                <td class="text-center"><?= $d->total_karyawan ?></td>
                                <td class="text-center text-primary fw-bold"><?= $d->total_transaksi ?></td>
                                <td class="text-center text-success fw-bold"><?= $d->total_item ?></td>
                            </tr>

                        <?php endforeach; ?>
                            <tr class="table-warning fw-bold text-center border-2 border-dark">
                                <td colspan="2" class="text-end pe-4">Total Keseluruhan Divisi</td>
                                <td><?= $total_karyawan_div ?></td>
                                <td><?= $total_transaksi_div ?></td>
                                <td><?= $total_item_div ?></td>
                            </tr>
                        <?php else: ?>
                            <tr>
                                <td colspan="5" class="text-center text-muted py-3">
                                    <i class="fa fa-info-circle me-1"></i> Belum ada data rekap per divisi pada periode ini.
                                </td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>

        </div>
    </div>
</div>