<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login - AsiaServ</title>

    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;600;700&display=swap" rel="stylesheet">
    <link rel="icon" href="<?= base_url('assets/img/asiaserv-logo.png') ?>" type="image/png">


    <style>
/* === RESET DAN GLOBAL === */
* {
    margin: 0;
    padding: 0;
    box-sizing: border-box;
}

body, html {
    font-family: 'Poppins', sans-serif;
    height: 100%;
    /* Menggunakan Flexbox untuk memusatkan konten */
    display: flex;
    justify-content: center;
    align-items: center;
    /* Mempertahankan pengaturan background Anda */
    background-image: url('<?= base_url('assets/img/log.jpg'); ?>');
    background-size: cover;
    background-position: center;
    background-repeat: no-repeat;
    background-attachment: fixed;
    color: #333;
}

/* === LOGIN CONTAINER === */
.login-container {
    width: 100%;
    padding: 20px;
    display: flex; 
    justify-content: center;
}

/* === LOGIN CARD (FIXED: Lebar dan Padding Seimbang) === */
.login-card {
    /* Lebar maksimum yang proporsional untuk tampilan login */
    width: 100%;
    max-width:1000px; 
    padding: 70px; 

    width: 500px;  /* Lebar diatur pas 900px */
    height: 650px;
    
    background: rgba(255, 255, 255, 0.9);
    border-radius: 20px;
    backdrop-filter: blur(10px); 
    -webkit-backdrop-filter: blur(10px);
      
    box-shadow: 0 15px 30px rgba(0, 0, 0, 0.15); 
    border: 1px solid rgba(255, 255, 255, 0.7);
    transition: all 0.3s ease-in-out;
    
    text-align: center; /
}

.login-card:hover {
    transform: translateY(-4px);
    box-shadow: 0 20px 40px rgba(0, 0, 0, 0.25);
}


.login-card form {
    width: 100%;
    max-width: 450px; 
    margin: 0 auto;
    text-align: center;
}


.login-card img {
    max-width: 200px; 
    height: auto;
    margin: 0 auto 30px; 
    display: block;
    transition: transform 0.3s ease;
}
.login-card img:hover {
    transform: scale(1.03);
}

/* === JUDUL === */
.login-card h3 {
    font-size: 32px;
    font-weight: 700;
    color: #007d91;
    margin-bottom: 20px;
    letter-spacing: 0.5px;
    text-shadow: 0 1px 3px rgba(0,0,0,0.05);
}

/* === FORM GROUP === */
.form-group {
    margin-bottom: 20px;
    position: relative;
    text-align: left;
}
.form-group label {
    font-size: 13px;
    font-weight: 600;
    color: #333;
    margin-bottom: 8px;
    display: block;
}

/* === INPUT === */
.input-icon-wrapper {
    position: relative;
}

.form-group input {
    /* Padding disesuaikan agar cocok dengan ikon di kiri */
    width: 100%;
    padding: 14px 18px 14px 45px; 
    font-size: 16px;
    border: 2px solid #e2e2e2;
    border-radius: 10px;
    background: rgba(255,255,255,0.95);
    transition: all 0.3s ease;
}
.form-group input:focus {
    border-color: #0097a7;
    box-shadow: 0 0 10px rgba(0,151,167,0.25);
    outline: none;
}

/* === ICONS === */
.input-icon-main {
    position: absolute;
    left: 14px; 
    top: 50%;
    transform: translateY(-50%);
    color: #888;
    font-size: 18px;
    pointer-events: none;
    transition: color 0.3s;
}
.input-icon-wrapper input:focus + .input-icon-main {
    color: #0097a7;
}

.toggle-password {
    position: absolute;
    right: 14px; 
    top: 50%;
    transform: translateY(-50%);
    color: #999;
    font-size: 18px;
    cursor: pointer;
    transition: color 0.3s;
    z-index: 10;
}
.toggle-password:hover {
    color: #0097a7;
}

/* === TOMBOL LOGIN === */
.login-button {
    width: 100%;
    padding: 15px;
    font-size: 19px;
    font-weight: 700;
    border: none;
    border-radius: 10px;
    color: #fff;
    background: linear-gradient(135deg, #0097a7, #007d91);
    box-shadow: 0 4px 15px rgba(0, 125, 145, 0.3);
    cursor: pointer;
    transition: all 0.3s ease;
}
.login-button:hover {
    background: linear-gradient(135deg, #007d91, #006c7a);
    transform: translateY(-2px);
}
.login-button:active {
    transform: scale(0.98);
}

/* === FOOTER === */
.footer-text {
    margin-top: 25px;
    font-size: 13px;
    color: #555;
    text-align: center;
}
.footer-text a {
    color: #0097a7;
    font-weight: 600;
    text-decoration: none;
}
.footer-text a:hover {
    text-decoration: underline;
}

/* === Perbaikan Error Validasi (Placeholder) === */
.text-danger {
    color: #e3342f; /* Merah cerah */
    font-size: 12px;
    display: block;
    margin-top: 4px;
}
</style>

</head>
<body>

<div class="login-container">
    <div class="login-card">
        <h3>Login</h3>
        <img src="<?= base_url('assets/img/asiaserv-logo.png'); ?>" alt="Logo AsiaServ">
        <div class="footer-text" style="margin-top: -20px; margin-bottom: 30px; font-size: 14px; color: #555;">
           
        </div>

        <form method="POST" action="<?= base_url('Auth/Login/ceklogin') ?>" autocomplete="off">
            <!-- Field Username --><div class="form-group">
                <label for="username">Account</label>
                <div class="input-icon-wrapper">
                    <input type="text" id="username" name="username" placeholder="Enter your username">
                    <span class="input-icon-main">👤</span> 
                </div>
                <!-- Placeholder untuk Error Validation --><small class="text-danger hidden">Username harus diisi.</small>
                <!-- <?= form_error('username', '<small class="text-danger">', '</small>') ?> --></div>
            
            <!-- Field Password --><div class="form-group">
                <label for="password">Password</label>
                <div class="input-icon-wrapper">
                    <input type="password" id="password" name="pass" placeholder="Enter your password" style="padding-right: 45px;">
                    <span class="input-icon-main">🔒</span>
                    
                    <span class="toggle-password" id="togglePassword">👁️</span> 
                </div>
                <!-- Placeholder untuk Error Validation --><small class="text-danger hidden">Password harus diisi.</small>
                <!-- <?= form_error('pass', '<small class="text-danger">', '</small>') ?> --></div>
            
            <button type="submit" class="login-button">Login</button>
        </form>
        
        <div class="footer-text">
            &copy; 2024 ASIASERV. All Rights Reserved
        </div>
    </div>
</div>

<script>
    document.addEventListener('DOMContentLoaded', function () {
        const togglePassword = document.getElementById('togglePassword');
        const passwordInput = document.getElementById('password');

        if (togglePassword && passwordInput) {
            togglePassword.addEventListener('click', function () {
                const type = passwordInput.getAttribute('type') === 'password' ? 'text' : 'password';
                passwordInput.setAttribute('type', type);
                
                if (type === 'text') {
                    togglePassword.textContent = '🙈'; 
                } else {
                    togglePassword.textContent = '👁️'; 
                }
            });
        }
    });
</script>

</body>
</html>