<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class ATK_cart_controller extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->library('session');
        $this->load->helper(['url', 'form']);
        $this->load->database();
        $this->load->model('Atk_Cart_Model');
    }

    // tampilkan keranjang
    public function index() {
        $data['keranjang'] = $this->session->userdata('keranjang') ?? [];
        $this->load->view('Admin/Atk_pengambilan/cart_view', $data);
    }

    // Tambah multiple barang ke keranjang
    public function tambah_multiple_keranjang() {
        $keranjang = $this->session->userdata('keranjang') ?? [];

        $peminjam = $this->input->post('atk_pengambilan_peminjam');
        $divisi   = $this->input->post('atk_pengambilan_divisi');
        $produk   = $this->input->post('produk_id');
        $jumlah   = $this->input->post('atk_pengambilan_jumlah');

        // Simpan peminjam & divisi di session
        $this->session->set_userdata('peminjam', $peminjam);
        $this->session->set_userdata('divisi', $divisi);

        foreach ($produk as $i => $produk_id) {
            $keranjang[] = [
                'id'        => uniqid(),
                'produk_id' => $produk_id,
                'jumlah'    => $jumlah[$i]
            ];
        }

        $this->session->set_userdata('keranjang', $keranjang);

        redirect('Admin/ATK/ATK_cart_controller');
    }

    // Hapus item dari keranjang
    public function hapus_item($index) {
        $keranjang = $this->session->userdata('keranjang') ?? [];
        if (isset($keranjang[$index])) {
            unset($keranjang[$index]);
            $keranjang = array_values($keranjang);
        }
        $this->session->set_userdata('keranjang', $keranjang);
        redirect('Admin/ATK/ATK_cart_controller');
    }

    // Checkout → simpan ke atk_pengambilan
    public function checkout() {
        $keranjang = $this->session->userdata('keranjang') ?? [];

        $peminjam = $this->session->userdata('peminjam');
        $divisi   = $this->session->userdata('divisi');

        if (empty($peminjam) || empty($divisi)) {
            $this->session->set_flashdata('pesan_error', 'Data peminjam atau divisi belum diisi.');
            redirect('Admin/ATK/ATK_cart_controller');
            return;
        }

        foreach ($keranjang as $item) {
            $data = [
                'atk_pengambilan_peminjam' => $peminjam,
                'atk_pengambilan_divisi'   => $divisi,
                'atk_pengambilan_product'  => $item['produk_id'],
                'atk_pengambilan_jumlah'   => $item['jumlah'],
                'atk_pengambilan_status'   => 1,
                'tanggal_pengambilan'      => date('Y-m-d H:i:s')
            ];
            $this->db->insert('atk_pengambilan', $data);
        }

        // kosongkan keranjang
        $this->session->unset_userdata('keranjang');
        $this->session->unset_userdata('peminjam');
        $this->session->unset_userdata('divisi');

        $this->session->set_flashdata('pesan_success', 'Checkout berhasil disimpan!');
        redirect('Admin/ATK/ATK_cart_controller');
    }
}
