<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Inventory_Types_Controller extends CI_Controller {

    public function __construct(){
		parent::__construct();
		$this->load->model("Inventory_Types_model");
		$this->load->library('session');
	}

	public function index()
	{
		$data["type"]=$this->Inventory_Types_model->getAll();
	    $this->load->view('Admin/head');
	    $this->load->view('Admin/Type/view',$data);
        $this->load->view('Admin/Type/add',$data);
		$this->load->view('Admin/footer');
	}

    public function input()
	{
		// $x['idKategori']=$this->kategori_model->autoId();
		$this->load->view('Admin/head');
		$this->load->view('Admin/Type/add');
		$this->load->view('Admin/footer');
	}

	
    public function tambah(){
		$Type = $this->Inventory_Types_model;
		$result =$Type->save();
		if($result > 0) $this->sukses();
		else $this->gagal();	
		
	}

	function sukses(){
        $this->session->set_flashdata('pesan_success', 'Data Tipe Inventori Berhasil Dibuat');
        redirect('Admin/Inventory/Inventory_Types_Controller');
	}

	function gagal(){
        $this->session->set_flashdata('pesan_error', 'Data Inventory Type berhasil dibuat');
        redirect('Admin/Inventory/Inventory_Types_Controller');
	}


    public function view_ubah($inventory_types_id) {
        $where = array('inventory_types_id' => $inventory_types_id);
        $data['type'] = $this->Inventory_Types_model->view_update($where, 'inventory_types')->row(); // Use row() for a single object
        $this->load->view('Admin/head');
        $this->load->view('Admin/Type/update', $data);
        $this->load->view('Admin/footer');
    }
    

    // Simpan Ubah ke Database
    public function update(){

		$post = $this->input->post();	
		$inventory_types_id 		= $this->input->post('inventory_types_id');
        $inventory_types_nama	= $this->input->post('inventory_types_nama');
        $inventory_types_description	= $this->input->post('inventory_types_description');
   

        $data = array(
			'inventory_types_id'         => $inventory_types_id,
			'inventory_types_nama'       => $inventory_types_nama,
            'inventory_types_description'       => $inventory_types_description,
			'inventory_types_status'     => 1
        );

        $where = array(
            'inventory_types_id'       => $inventory_types_id
        );

        $this->Inventory_Types_model->update($where,$data,'inventory_types');
        $this->session->set_flashdata('pesan_success', 'Data Tipe Inventori Berhasil Diubah');
        redirect('Admin/Inventory/Inventory_Types_Controller');
    }

	public function hapus($inventory_types_id){
		$data = array(
            'inventory_types_id'       => $inventory_types_id,
            'inventory_types_status'        => 0
        );

        $where = array(
            'inventory_types_id'       => $inventory_types_id
        );
        $this->Inventory_Types_model->update($where,$data,'inventory_types');
        $this->session->set_flashdata('pesan_success', 'Data Tipe Inventori Berhasil Dihapus');
        redirect('Admin/Inventory/Inventory_Types_Controller');
    }

    
}
?>