<!-- Modal Form Tambah Inventory -->
<div class="modal fade" id="InventoryModal1" tabindex="-1" aria-labelledby="InventoryModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered modal-lg">
    <div class="modal-content shadow-lg border-0 rounded-3">

      <!-- Modal Header -->
      <div class="modal-header bg-primary text-white">
        <h5 class="modal-title fw-bold" id="InventoryModalLabel">
          <i class="fas fa-boxes me-2"></i> Stationery Requisition Form
        </h5>
        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
      </div>

      <!-- Form utama -->
      <form action="<?= site_url('Admin/ATK/Atk_Pengambilan_Controller/tambah_user'); ?>" method="post">
        <div class="modal-body">
          
          <!-- Nama + Divisi + Lokasi -->
          <div class="mb-3">
            <label for="nama_peminjam" class="form-label fw-semibold">Full Name</label>
            <input type="text" name="nama_peminjam" class="form-control" placeholder="Enter your full name" required>
          </div>

          <div class="row g-3">
            <div class="col-md-6">
              <label for="atk_pengambilan_divisi" class="form-label fw-semibold">Division of Origin</label>
              <select class="form-select" id="atk_pengambilan_divisi" name="atk_pengambilan_divisi" required>
                <option value="">-- Select Division --</option>
                <?php foreach ($divisi as $inventory): ?>
                  <option value="<?= $inventory->divisi_categories_id; ?>">
                    <?= $inventory->divisi_categories_nama; ?>
                  </option>
                <?php endforeach; ?>
              </select>
            </div>
            <div class="col-md-6">
              <label for="atk_pengambilan_lokasi" class="form-label fw-semibold">Location</label>
              <select class="form-select" id="atk_pengambilan_lokasi" name="atk_pengambilan_lokasi" required>
                <option value="">-- Select Location --</option>
                <?php foreach ($lokasi as $loc): ?>
                  <option value="<?= $loc->inventory_location_id; ?>">
                    <?= $loc->inventory_location_nama; ?>
                  </option>
                <?php endforeach; ?>
              </select>
            </div>
          </div>

          <!-- Barang dinamis -->
          <div class="mt-4">
            <h6 class="fw-bold mb-3">Select Items</h6>
            <table class="table table-bordered align-middle text-center" id="barangTable">
              <thead class="table-light">
                <tr>
                  <th width="25%">ATK Categories</th>
                  <th width="35%">ATK Name</th>
                  <th width="20%">Quantity</th>
                  <th width="10%">Action</th>
                </tr>
              </thead>
              <tbody>
                <tr>
                  <td>
                    <select class="form-select" name="atk_product_categories[]" onchange="getProducts(this)" required>
                      <option value="">-- Select Category --</option>
                      <?php foreach ($kategori as $inventory): ?>
                        <option value="<?= $inventory->atk_categories_id; ?>">
                          <?= $inventory->atk_categories_nama; ?>
                        </option>
                      <?php endforeach; ?>
                    </select>
                  </td>
                  <td>
                    <select class="form-select" name="produk_id[]" onchange="getStock(this)" required>
                      <option value="">-- Select Product --</option>
                      <?php foreach ($products as $row): ?>
                        <option value="<?= $row->atk_product_id ?>" data-stock="<?= $row->atk_product_stok ?>">
                          <?= $row->atk_product_nama ?>
                        </option>
                      <?php endforeach; ?>
                    </select>
                    <small class="text-muted stok-info"></small>
                  </td>
                  <td>
                    <input type="number" name="atk_pengambilan_jumlah[]" class="form-control jumlah-input" min="1" value="1" required>
                    <div class="text-danger stok-error small"></div>
                  </td>
                  <td>
                    <button type="button" class="btn btn-sm btn-outline-danger removeRow">
                      <i class="fas fa-trash-alt"></i>
                    </button>
                  </td>
                </tr>
              </tbody>
            </table>
            <button type="button" class="btn btn-outline-secondary btn-sm mt-2" id="addRow">
              <i class="fas fa-plus me-1"></i> Add Item
            </button>
          </div>
        </div>

        <!-- Modal Footer -->
        <div class="modal-footer">
          <button type="submit" class="btn btn-primary">
            <i class="fas fa-save me-1"></i> Save
          </button>
          <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
            <i class="fas fa-times me-1"></i> Close
          </button>
        </div>
      </form>
    </div>
  </div>
</div>

<!-- Script jQuery -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
let stokTersedia = 0;

// Tambah baris barang
$("#addRow").click(function(){
  let row = $("#barangTable tbody tr:first").clone();
  row.find("select").val("");
  row.find("input").val(1);
  row.find(".stok-info").text("");
  row.find(".stok-error").text("");
  $("#barangTable tbody").append(row);
});

// Hapus baris
$(document).on("click", ".removeRow", function(){
  if ($("#barangTable tbody tr").length > 1) {
    $(this).closest("tr").remove();
  }
});

// Ambil produk berdasarkan kategori + lokasi
function getProducts(selectEl) {
  let categoryId = $(selectEl).val();
  let row = $(selectEl).closest("tr");
  let productSelect = row.find("select[name='produk_id[]']");
  productSelect.html('<option value="">-- Select Product --</option>');
  row.find(".stok-info").text("");

  let lokasiId = $("#atk_pengambilan_lokasi").val();

  if (categoryId !== "" && lokasiId !== "") {
    $.ajax({
      url: "<?= site_url('Admin/ATK/Atk_Pengambilan_Controller/getProductsByCategory') ?>",
      type: "POST",
      data: { category_id: categoryId, location_id: lokasiId },
      dataType: "json",
      success: function(response) {
        $.each(response, function(index, item) {
          productSelect.append(
            '<option value="' + item.atk_product_id + '" data-stock="' + item.atk_product_stok + '">' + item.atk_product_nama + '</option>'
          );
        });
      }
    });
  }
}

// Ambil stok & tampilkan
function getStock(selectEl) {
  let row = $(selectEl).closest("tr");
  let selectedProduct = $(selectEl).find("option:selected");
  let stokTersedia = parseInt(selectedProduct.data("stock")) || 0;
  row.find(".stok-info").text("Stock available: " + stokTersedia);
}
</script>
