<!DOCTYPE html>
<head>
    <meta charset="UTF-8">
    <title>Sistem Pengambilan ATK</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css" />
    <link href="https://fonts.googleapis.com/css2?family=Poppins&display=swap" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">

    <style>
        body {
            background-color: #f8f9fa;
            font-family: 'Poppins', sans-serif;
        }

        /* Navbar Styling */
        .navbar {
            background-color: #ffffff;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
            padding: 10px 20px;
        }

        .navbar-brand img {
            height: 45px;
        }

        .navbar-nav .nav-link {
            font-weight: 500;
            color: #333;
            margin-left: 15px;
            transition: 0.3s;
        }

        .navbar-nav .nav-link:hover {
            color: #28a745;
        }

        /* Hero Section */
        .hero-section {
            height: 80vh;
            display: flex;
            justify-content: center;
            align-items: center;
            text-align: center;
            background: linear-gradient(rgba(0, 0, 0, 0.6), rgba(0, 0, 0, 0.6)),
                url('https://source.unsplash.com/1600x900/?office,workspace') no-repeat center center/cover;
            color: white;
            padding: 50px 20px;
        }

        .hero-section h1 {
            font-size: 3rem;
            font-weight: bold;
        }

        .hero-section p {
            font-size: 1.2rem;
            margin: 15px 0 25px;
        }

        /* Button Custom */
        .btn-custom {
            font-size: 1.1rem;
            padding: 12px 30px;
            border-radius: 50px;
            background: linear-gradient(45deg, #28a745, #218838);
            border: none;
            transition: 0.3s;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.3);
        }

        .btn-custom:hover {
            transform: scale(1.05);
            box-shadow: 0 6px 16px rgba(0, 0, 0, 0.4);
        }

        /* Contact Section */
        .contact-container {
            background: #ffffff;
            padding: 40px;
            border-radius: 12px;
            max-width: 1000px;
            margin: 60px auto;
            box-shadow: 0 6px 20px rgba(0, 0, 0, 0.1);
        }

        .contact-title {
            font-size: 2rem;
            font-weight: bold;
            text-align: center;
            margin-bottom: 35px;
            color: #333;
        }

        .contact-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 25px;
        }

        .contact-item {
            padding: 20px;
            background: #f9f9f9;
            border-radius: 10px;
            text-align: center;
            transition: 0.3s;
            border: 1px solid #eee;
        }

        .contact-item:hover {
            transform: translateY(-5px);
            background: #ffffff;
            box-shadow: 0 6px 18px rgba(0, 0, 0, 0.15);
        }

        .contact-item h4 {
            font-size: 1.3rem;
            font-weight: bold;
            margin-bottom: 10px;
            color: #28a745;
        }

        .whatsapp-link {
            display: inline-flex;
            align-items: center;
            color: #25D366;
            font-weight: bold;
            text-decoration: none;
            margin-top: 10px;
        }

        .whatsapp-link i {
            font-size: 1.5rem;
            margin-right: 8px;
        }

        /* Responsive */
        @media (max-width: 768px) {
            .hero-section {
                height: 70vh;
                padding: 30px 10px;
            }

            .hero-section h1 {
                font-size: 2rem;
            }

            .hero-section p {
                font-size: 1rem;
            }

            .btn-custom {
                font-size: 1rem;
                padding: 10px 22px;
            }
        }
    </style>
</head>

<body>

    <!-- Navbar -->
    <!-- Navbar -->
<nav class="navbar navbar-light">
    <div class="container-fluid">
        <a href="index.html" class="navbar-brand">
            <img src="<?= base_url('/assets/img/asiaserv-logo.png'); ?>" alt="AsiaServ Logo" style="height: 80px; width: auto;">
        </a>
    </div>
</nav>


    <!-- Flash Messages -->
    <div id="flash" data-flash="<?= $this->session->flashdata('pesan_success'); ?>"></div>

    <?php if ($this->session->flashdata('pesan_error')): ?>
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            <?= $this->session->flashdata('pesan_error'); ?>
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    <?php endif; ?>

    <?php if ($this->session->flashdata('success')): ?>
        <div class="alert alert-success">
            <?= $this->session->flashdata('success'); ?>
        </div>
    <?php endif; ?>

    <!-- Hero Section -->
    <section class="hero-section">
        <div>
            <h1>Stationery Supply System</h1>
            <p>Manage And Record Office Stationery Usage Easily And Quickly</p>
            <a href="#" data-bs-toggle="modal" data-bs-target="#InventoryModal1" class="btn btn-custom">
                <i class="fas fa-plus-circle"></i> Add Data
            </a>
        </div>
    </section>
<!-- Contact Section -->
<div class="contact-container" style="text-align: left;">
    <div class="contact-title">Contact Us</div>
    <div class="contact-grid">
        <div class="contact-item" style="text-align: left;">
            <h4><i class="fas fa-user-tie"></i> Contact GA</h4>
            <p><strong>Name:</strong> Oki Awaludin</p>
            <p><strong>Email:</strong> oki.awaludin@gmail.com</p>
            <p>
                <a href="https://wa.me/6285718101532" target="_blank" class="whatsapp-link">
                    <i class="fa-brands fa-whatsapp"></i> Chat via WhatsApp
                </a>
            </p>
        </div>
    </div>
</div>


</body>
