<!-- Main Container -->
<div class="container-fluid pt-4 px-4">
    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <div class="row align-items-center">
                <!-- Judul di kiri -->
                <div class="col-md-6">
                    <span class="text-primary fw-bold">Retrieval Data</span>
                </div>
                <style>
                    .btn-top {
                    min-width: 118px;
                    text-align: center;
                    line-height: 1.0;
                    }

                    .btn-success, .btn-primary {
                    display: inline-flex;
                    align-items: center;
                    justify-content: center;
                    height: 39px;
                    }
                </style>

                <!-- Tombol Aksi -->
        <div class="col-md-6 text-end">
          <a href="<?= site_url('Admin/ATK/Atk_Pengambilan_Controller/cetak_pdf?filter_produk=' . urlencode($filter_produk) . '&filter_divisi=' . urlencode($filter_divisi) . '&filter_lokasi=' . urlencode($filter_lokasi)) ?>" 
             id="btn-cetak-pdf" class="btn btn-sm btn-outline-primary me-2">
             <i class="fas fa-file-pdf me-1"></i> PDF
          </a>

          <a href="<?= site_url('Admin/ATK/Atk_Pengambilan_Controller/export_excel?filter_produk=' . urlencode($filter_produk) . '&filter_divisi=' . urlencode($filter_divisi)) ?>" 
             class="btn btn-sm btn-outline-success me-2">
             <i class="fas fa-file-excel me-1"></i> Excel
          </a>

          <a href="<?= site_url('Admin/ATK/Atk_Pengambilan_Controller/tambah'); ?>"
            class="btn btn-sm btn-primary btn-add-data"
            data-bs-toggle="modal" data-bs-target="#InventoryModal">
            <i class="fas fa-plus me-1"></i> Add Data
        </a>
        </div>
    </div>
</div>

        <style>
        .btn-add-data {
            padding: 2px 8px;       /* perkecil padding */
            font-size: 0.8rem;      /* perkecil teks */
            line-height: 1.1;       /* rapetin tinggi tombol */
            border-radius: 4px;     /* biar tetap proporsional */
        }
        </style>


                <!-- Filter Section -->
        <div class="card-body border-bottom">
           <form action="<?= site_url('Admin/ATK/Atk_Pengambilan_Controller/index'); ?>" method="get">
    <div class="row">
        <!-- Filter Produk -->
        <div class="col-md-6 col-lg-4 mb-3">
            <label class="form-label text-muted">Filter by Produk:</label>
            <select class="form-control" name="filter_produk">
                <option value="">All Produk</option>
                <?php foreach ($produk as $p): ?>
                    <option value="<?= $p->atk_product_id ?>" <?= ($filter_produk == $p->atk_product_id ? 'selected' : '') ?>>
                        <?= $p->atk_product_nama ?>
                    </option>
                <?php endforeach; ?>
            </select>
        </div>

        <!-- Filter Divisi -->
        <div class="col-md-6 col-lg-4 mb-3">
            <label class="form-label text-muted">Filter by Divisi:</label>
            <select class="form-control" name="filter_divisi">
                <option value="">All Divisi</option>
                <?php foreach ($divisi as $d): ?>
                    <option value="<?= $d->divisi_categories_id ?>" <?= ($filter_divisi == $d->divisi_categories_id ? 'selected' : '') ?>>
                        <?= $d->divisi_categories_nama ?>
                    </option>
                <?php endforeach; ?>
            </select>
        </div>

        <!-- Filter Lokasi -->
        <div class="col-md-6 col-lg-4 mb-3">
            <label class="form-label text-muted">Filter by Location:</label>
            <select class="form-control" name="filter_lokasi">
                <option value="">All Location</option>
                <?php foreach ($lokasi as $l): ?>
                    <option value="<?= $l->inventory_location_id ?>" <?= ($filter_lokasi == $l->inventory_location_id ? 'selected' : '') ?>>
                        <?= $l->inventory_location_nama ?>
                    </option>
                <?php endforeach; ?>
            </select>
        </div>
    </div>

    <button type="submit" class="btn btn-primary">Apply Filter</button>
</form>

        <div class="card-body"> 
            <!-- Flash Messages -->
            <div id="flash" data-flash="<?= $this->session->flashdata('pesan_success'); ?>"></div>
            <?php if ($this->session->flashdata('pesan_error')): ?>
                <div class="alert alert-danger alert-dismissible bg-danger text-white border-0 fade show" role="alert">
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="Close"></button>
                    <?= $this->session->flashdata('pesan_error'); ?>
                </div>
            <?php endif; ?>
<?php if ($this->session->flashdata('success')): ?>
  <div class="alert alert-success"><?= $this->session->flashdata('success') ?></div>
<?php endif; ?>
            <!-- Data Table -->
            <div class="table-responsive">
                <table class="table table-bordered table-hover table-striped" id="datatables">
                        <thead>
                            <tr>
                                <th class="text-center">No.</th>
                                <th class="text-center">Name</th>
                                <th class="text-center">Division</th>
                                <th class="text-center">Location</th>
                                <th class="text-center">Product ATK</th>
                                <th class="text-center">Count</th>
                                <th class="text-center">Pickup Date</th>
                                <th class="text-center">Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $i = 1; ?>
                            <?php foreach ($pengambilan as $k): ?>
                                <tr>
                                    <td class="text-center"><?= $i++; ?></td>
                                    <td><?= $k->atk_pengambilan_peminjam; ?></td>
                                    <td class="text-center"><?= $k->divisi_categories_nama; ?></td>
                                    <td class="text-center"><?= $k->inventory_location_nama; ?></td>
                                    <td class="text-center"><?= $k->atk_product_nama; ?></td> <!-- Nama Location -->
                                    <td class="text-center"><?= $k->atk_pengambilan_jumlah; ?></td>
                                    <td class="text-center">
                                    <?= date('d-m-Y', strtotime($k->tanggal_pengambilan)); ?>
                                    </td>
                              

                                    <td class="text-center">
                                        <a href="<?= site_url('Admin/ATK/Atk_Pengambilan_Controller/view_ubah/'.$k->id); ?>" class="btn btn-warning btn-sm">
                                            <i class="fa fa-edit"></i>
                                        </a>
                                        <a href="<?= base_url('Admin/ATK/Atk_Pengambilan_Controller/hapus/'.$k->id); ?>" class="btn btn-danger btn-sm" id="tombol-hapus">
                                            <i class="fa fa-trash"></i>
                                        </a>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>

                </table>
            </div>  
        </div>
    </div>
</div>



<!-- pastikan hanya satu kali include jQuery + DataTables (letakkan di head/footer) -->
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.8/css/dataTables.bootstrap5.min.css">
<script src="https://code.jquery.com/jquery-3.7.1.min.js"></    script>
<script src="https://cdn.datatables.net/1.13.8/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.13.8/js/dataTables.bootstrap5.min.js"></script>

<!-- jsPDF (untuk cetak PDF) -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/2.5.1/jspdf.umd.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf-autotable/3.5.28/jspdf.plugin.autotable.min.js"></script>

<script>
$(document).ready(function () {
  // Hapus instance lama sebelum bikin baru
  if ($.fn.DataTable.isDataTable('#datatables')) {
    $('#datatables').DataTable().clear().destroy();
  }

  // Inisialisasi ulang
  var table = $('#datatables').DataTable({
    ordering: true,
    searching: true,
    paging: true,
    columnDefs: [
      { orderable: false, targets: -1 }
    ]
     order: [[6, "desc"]]
  });
});


  // === FILTER PRODUK ===
  $('#filter-produk').on('change', function () {
    var val = ($(this).val() || '').toString().trim();
    console.log("Filter dipilih:", val);
    table.column(3).search(val).draw(); // kolom ke-3 = Produk
  });

  // === FILTER DIVISI ===
  $('#filter-divisi').on('change', function () {
    table.column(2).search(this.value).draw(); // kolom ke-2 = Divisi
  });

  // === FILTER LOKASI ===
  $('#filter-lokasi').on('change', function () {
    table.column(4).search(this.value).draw(); // kolom ke-4 = Lokasi
  });

  // === CETAK PDF ===
  $('#btn-cetak-pdf').off('click').on('click', function (e) {
    e.preventDefault();
    const { jsPDF } = window.jspdf;
    const doc = new jsPDF();

    doc.text("Laporan ATK Category Data", 14, 15);

    var headers = $('#datatables thead th').map(function(){ return $(this).text().trim(); }).get();
    headers.pop();

    var body = [];
    table.rows({ search: 'applied' }).every(function () {
      var row = this.data();
      if ($.isArray(row)) {
        row = row.slice(0, headers.length);
      } else {
        var cells = $(this.node()).find('td').map(function(){ return $(this).text().trim(); }).get();
        row = cells.slice(0, headers.length);
      }
      body.push(row);
    });

    doc.autoTable({ head: [headers], body: body, startY: 20, theme: 'grid' });
    doc.save('atk_category_data.pdf');
  });

</script>





