<!-- Main Container -->
<div class="container-fluid pt-4 px-4">
    <div class="card shadow mb-4">
        <!-- Card Header -->
        <div class="card-header py-3 d-flex justify-content-between align-items-center">
            <h6 class="m-0 font-weight-bold text-primary">Product Master ATK</h6>
            <div>
                <a href="<?php echo site_url('Admin/ATK/Atk_Product_Controller/input'); ?>" class="btn btn-success btn-sm" data-bs-toggle="modal" data-bs-target="#InventoryModal">
                    <i class="fa fa-plus"></i> Add Data
                </a>
                <a id="exportExcelBtn" class="btn btn-primary btn-sm">
                    <i class="fa fa-file-excel"></i> Export Excel
                </a>
                 <a id="exportPdfBtn" class="btn btn-danger btn-sm">
                    <i class="fa fa-file-pdf"></i> Export PDF
                </a>
            </div>
        </div>

        <!-- Filter Section -->
        <div class="card-body border-bottom">
            
            <form action="<?php echo site_url('Admin/ATK/Atk_Product_Controller/index'); ?>" method="get">
                <div class="row">
                    <!-- Filter Kategori -->
                    <div class="col-md-6 col-lg-4 mb-3">
                        <label class="form-label text-muted">Filter by Kategori:</label>
                        <select class="form-control" name="filter_kategori" onchange="this.form.submit()">
                            <option value="">All Kategori</option>
                            <?php 
                                foreach ($kategori as $k) {
                                    $selected = ($filter_kategori == $k->atk_categories_id) ? 'selected' : '';
                                    echo "<option value='{$k->atk_categories_id}' {$selected}>{$k->atk_categories_nama}</option>";
                                }
                            ?>
                        </select>
                    </div>

                    <!-- Filter Lokasi -->
                    <div class="col-md-6 col-lg-4 mb-3">
                        <label class="form-label text-muted">Filter by Lokasi:</label>
                        <select class="form-control" name="filter_lokasi" onchange="this.form.submit()">
                            <option value="">All Location</option>
                            <?php 
                                foreach ($location as $k) {
                                    $selected = ($filter_lokasi == $k->inventory_location_id) ? 'selected' : '';
                                    echo "<option value='{$k->inventory_location_id}' {$selected}>{$k->inventory_location_nama}</option>";
                                }
                            ?>
                        </select>
                    </div>

                    
                </div>
            </form>
        </div>

        <!-- Card Body -->
        <div class="card-body">
            <!-- Flash Messages -->
            <div id="flash" data-flash="<?= $this->session->flashdata('pesan_success'); ?>"></div>
            <?php if ($this->session->flashdata('pesan_error')): ?>
                <div class="alert alert-danger alert-dismissible bg-danger text-white border-0 fade show" role="alert">
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="Close"></button>
                    <?= $this->session->flashdata('pesan_error'); ?>
                </div>
            <?php endif; ?>

            <!-- Data Table -->
            <div class="table-responsive">
                <table class="table table-bordered table-hover table-striped" id="datatables">
                    <thead>
                        <tr>
                            <th class="text-center">No.</th>
                            <th class="text-center">ATK Name</th>
                            <th class="text-center">Brand</th>
                            <th class="text-center">Category</th>
                            <th class="text-center">Inventory</th>
                            <th class="text-center">Unit</th>
                            <th class="text-center">Location</th>
                            <th class="text-center">Notes</th>
                            <th class="text-center">Update Date</th>
                            <th class="text-center">Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $i = 1; ?>
                        <?php foreach ($product as $k): ?>
                            <tr>
                                <td class="text-center"><?= $i++; ?></td>
                                <td><?= $k->atk_product_nama; ?></td>
                                <td><?= $k->brand_categories_nama; ?></td>
                                <td><?= $k->atk_categories_nama; ?></td>
                                <td><?= $k->atk_product_stok; ?></td>
                                <td><?= $k->uom_categories_nama; ?></td>
                                <td><?= $k->inventory_location_nama; ?></td>
                                <td><?= $k->atk_product_notes; ?></td>
                                <td><?= date("d-m-Y H:i", strtotime($k->update_date)); ?></td>
                                <td class="text-center">
                                    <a href="<?= site_url('Admin/ATK/Atk_Product_Controller/view_ubah/'.$k->atk_product_id); ?>" class="btn btn-warning btn-sm">
                                        <i class="fa fa-edit"></i>
                                    </a>
                                    <a href="<?= base_url('Admin/ATK/Atk_Product_Controller/hapus/'.$k->atk_product_id); ?>" class="btn btn-danger btn-sm" id="tombol-hapus">
                                        <i class="fa fa-trash"></i>
                                    </a>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<!-- Include Bootstrap and other required JS -->
<script>
    $(document).ready(function() {
        $('#datatables').DataTable({
            dom: 'Bfrtip',
            buttons: ['copy', 'excel', 'pdf', 'print'],
            responsive: true
        });
    });
</script>

<script>
    document.getElementById('exportExcelBtn').addEventListener('click', function() {
        // Ambil nilai filter dari form
        var filterKategori = document.querySelector('select[name="filter_kategori"]').value;
        var filterLokasi = document.querySelector('select[name="filter_lokasi"]').value;

        // Buat URL untuk ekspor
        var url = "<?php echo site_url('Admin/ATK/Atk_Product_Controller/export_excel'); ?>";
        url += '?filter_kategori=' + encodeURIComponent(filterKategori);
        url += '&filter_lokasi=' + encodeURIComponent(filterLokasi);

        // Redirect ke URL ekspor
        window.location.href = url;
    });
    document.getElementById('exportPdfBtn').addEventListener('click', function() {
    // Ambil nilai filter dari form
    var filterKategori = document.querySelector('select[name="filter_kategori"]').value;
    var filterLokasi = document.querySelector('select[name="filter_lokasi"]').value;

    // Buat URL untuk ekspor PDF
    var url = "<?php echo site_url('Admin/ATK/Atk_Product_Controller/export_pdf'); ?>";
    url += '?filter_kategori=' + encodeURIComponent(filterKategori);
    url += '&filter_lokasi=' + encodeURIComponent(filterLokasi);

    // Redirect ke URL ekspor
    window.location.href = url;
});
</script>