<!-- Sale & Revenue Start -->
<div class="container-fluid pt-2 px-4"> 

    <!-- Flash Message -->
    <div id="flash" data-flash="<?=$this->session->flashdata('pesan_success'); ?>"></div>
    <div id="flash_error" data-flash="<?=$this->session->flashdata('pesan_error'); ?>"></div>
    <?php if ($this->session->flashdata('pesan_error')): ?>
        <div class="alert alert-danger alert-dismissible bg-danger text-white border-0 fade show" role="alert">
            <button type="button" class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="Close"></button>
            <?= $this->session->flashdata('pesan_error'); ?>
        </div>
    <?php endif; ?>

    <!-- Card Summary -->
    <div class="row g-4 mb-4">
        <div class="col-sm-6 col-xl-6">
            <a href="<?= site_url('Admin/Admin_Dashboard_Controller/rekap_pengambilan') ?>" class="text-decoration-none">
                <div class="bg-light rounded d-flex align-items-center justify-content-between p-4 hover-shadow">
                    <i class="fa fa-users fa-3x text-primary"></i>
                    <div class="ms-3">
                        <p class="mb-2">Summary of Employees Colleting Office Supplies</p> 
                        <h6 class="mb-0 text-dark"></h6>
                    </div>
                </div>
            </a>
        </div>

        <div class="col-sm-6 col-xl-6">
            <a href="<?= site_url('Admin/Inventory/Inventory_Controller/dashboard'); ?>" class="text-decoration-none">
                <div class="bg-light rounded d-flex align-items-center justify-content-between p-4 hover-shadow">
                    <i class="fa fa-archive fa-3x text-primary"></i>
                    <div class="ms-3">
                        <p class="mb-2 text-dark">Summary Of Avaible Inventory</p>
                        <h6 class="mb-0 text-dark"></h6>
                    </div>
                </div>
            </a>
        </div>
    </div>

    <!-- Filter + Chart -->
    <div class="row g-4">
        <!-- Filter -->
        <div class="col-12">
            <div class="bg-light rounded p-4 mb-4">
                <form method="get" action="<?= site_url('Admin/Admin_Dashboard_Controller/index') ?>" class="row g-2 align-items-center">
                    <div class="col-auto">
                        <select name="bulan" class="form-select">
                            <option value="" <?= ($bulan_filter == "") ? "selected" : "" ?>>All Month</option>
                            <?php 
                            $nama_bulan = [
                                1=>"Januari",2=>"Februari",3=>"Maret",4=>"April",5=>"Mei",6=>"Juni",
                                7=>"Juli",8=>"Agustus",9=>"September",10=>"Oktober",11=>"November",12=>"Desember"
                            ];
                            foreach ($nama_bulan as $key => $nama) {
                                $selected = ($bulan_filter == $key) ? "selected" : ""; 
                                echo "<option value='$key' $selected>$nama</option>";
                            }
                            ?>
                        </select>
                    </div>
                    <div class="col-auto">
                        <select name="tahun" class="form-select">
                            <?php 
                            $tahun_sekarang = date('Y');
                            for ($t = $tahun_sekarang; $t >= $tahun_sekarang - 5; $t--) {
                                $selected = ($tahun_filter == $t) ? "selected" : "";
                                echo "<option value='$t' $selected>$t</option>";
                            }
                            ?>
                        </select>
                    </div>
                    <div class="col-auto">
                        <button type="submit" class="btn btn-primary">Filter</button>
                    </div>
                </form>
            </div>
        </div>

       <!-- Chart Per Bulan -->
<div class="col-12">
    <div class="bg-light rounded p-4 mb-4">
        <h5 class="mb-4 text-dark">Monthly Collection Diagram</h5>
        <canvas id="atkChart" height="60"></canvas>
    </div>
</div>

<!-- Chart Per Minggu -->
<?php if (!empty($bulan_filter)) : ?>
<div class="col-12">
    <div class="bg-light rounded p-4">
        <h5 class="mb-4 text-dark">Weekly Collection Diagram</h5>
        <canvas id="atkChartMinggu" height="60"></canvas>
    </div>
</div>
<?php endif; ?>
</div>
</div>
<!-- Sale & Revenue End -->

<style>
    .hover-shadow:hover {
        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.2);
        transition: 0.3s;
    }
    #atkChart, #atkChartMinggu {
        max-height: 300px;
    }
</style>

<!-- Chart.js -->
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
    // --- Chart Per Bulan ---
    const bulan  = <?= json_encode($bulan ?? []) ?>;
    const jumlah = <?= json_encode($jumlah ?? []) ?>;
    const atkList = <?= json_encode($atk_list ?? []) ?>;

    if (document.getElementById('atkChart')) {
        const ctxBulan = document.getElementById('atkChart').getContext('2d');
        new Chart(ctxBulan, {
            type: 'bar',
            data: {
                labels: bulan,
                datasets: [{
                    label: 'Jumlah Pengambilan ATK (Bulanan)',
                    data: jumlah,
                    backgroundColor: 'rgba(54, 162, 235, 0.7)',
                    borderColor: 'rgba(54, 162, 235, 1)',
                    borderWidth: 1,
                    categoryPercentage: 0.5, 
                    barPercentage: 0.5
                }]
            },
            options: {
                responsive: true,
                plugins: { 
                    title: {
                        display: true,
                        text: 'Monthly Collection Diagram',
                        font: { size: 16, weight: 'bold' }
                    },
                    legend: { display: true, position: 'top' },
                    tooltip: {
                        callbacks: {
                            label: function(context) {
                                const atk = atkList[context.dataIndex] || "-";
                                let items = atk.split(",");
                                let lines = [];
                                lines.push(context.dataset.label + ': ' + context.parsed.y);
                                lines.push('ATK:');
                                items.forEach(i => lines.push('- ' + i.trim()));
                                return lines;
                            }
                        }
                    }
                },
                scales: { 
                    x: { title: { display: true, text: 'Bulan ke-' } },
                    y: { beginAtZero: true, title: { display: true, text: 'Jumlah Pengambilan' } }
                },
                animation: { duration: 1000, easing: 'easeOutBounce' }
            }
        });
    }

    // --- Chart Per Minggu (hanya kalau pilih bulan) ---
    <?php if (!empty($bulan_filter)) : ?>
    const minggu  = <?= json_encode($minggu ?? []) ?>;
    const jumlahMinggu = <?= json_encode($jumlah_minggu ?? []) ?>;

    if (document.getElementById('atkChartMinggu')) {
        if (minggu.length > 0) {
            const ctxMinggu = document.getElementById('atkChartMinggu').getContext('2d');
            new Chart(ctxMinggu, {
                type: 'bar',
                data: {
                    labels: minggu,
                    datasets: [{
                        label: 'Jumlah Pengambilan ATK (Mingguan)',
                        data: jumlahMinggu,
                        borderColor: 'rgba(255, 99, 132, 1)',
                        backgroundColor: 'rgba(255, 99, 132, 0.2)',
                        borderWidth: 2,
                        barPercentage: 0.6,
                        categoryPercentage: 0.6,
                        maxBarThickness: 40
                    }]
                },
                options: {
                    responsive: true,
                    plugins: { 
                        title: {
                            display: true,
                            text: 'Weekly Collection Diagram',
                            font: { size: 16, weight: 'bold' }
                        },
                        legend: { display: true, position: 'top' },
                        tooltip: {
                            callbacks: {
                                label: function(context) {
                                    return 'Jumlah: ' + context.raw;
                                }
                            }
                        }
                    },
                    scales: { 
                        x: { title: { display: true, text: 'Minggu ke-' } },
                        y: { beginAtZero: true, title: { display: true, text: 'Jumlah Pengambilan' } }
                    },
                    animation: { duration: 1000, easing: 'easeOutBounce' }
                }
            });
        } else {
            document.getElementById('atkChartMinggu').outerHTML = "<p class='text-center text-muted'>Tidak ada data untuk minggu ini</p>";
        }
    }
    <?php endif; ?>
</script>
