<div class="container-fluid pt-4 px-4">

    <!-- Filter Card -->
    <div class="card mb-4 shadow-sm">
        <div class="card-body">
            <form method="get" action="<?= site_url('Admin/Inventory/Inventory_Controller/dashboard') ?>" class="row g-3 align-items-center">
                
                <!-- Filter Kategori -->
                <div class="col-md-4">
                    <label class="form-label fw-semibold">Kategori</label>
                    <select name="filter_kategori" class="form-select">
                        <option value="">-- Semua Kategori --</option>
                        <?php foreach($categories as $cat): ?>
                            <option value="<?= $cat->atk_categories_id ?>" 
                                <?= ($this->input->get('filter_kategori') == $cat->atk_categories_id) ? 'selected' : '' ?>>
                                <?= htmlspecialchars($cat->atk_categories_nama) ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>

                <!-- Filter Lokasi -->
                <div class="col-md-4">
                    <label class="form-label fw-semibold">Lokasi</label>
                    <select name="filter_lokasi" class="form-select">
                        <option value="">-- Semua Lokasi --</option>
                        <?php foreach($locations as $loc): ?>
                            <option value="<?= $loc->inventory_location_id ?>" 
                                <?= ($this->input->get('filter_lokasi') == $loc->inventory_location_id) ? 'selected' : '' ?>>
                                <?= htmlspecialchars($loc->inventory_location_nama) ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>

                <!-- Buttons -->
                <div class="col-md-4 d-flex align-items-end">
                    <button type="submit" class="btn btn-primary me-2">
                        <i class="fa fa-filter"></i> Filter
                    </button>
                    <a href="<?= site_url('Admin/Inventory/Inventory_Controller/dashboard') ?>" class="btn btn-outline-secondary">
                        <i class="fa fa-undo"></i> Reset
                    </a>
                </div>

            </form>
        </div>
    </div>

    <!-- Produk Cards -->
    <div class="row g-4">
        <?php if(!empty($product)): ?>
            <?php foreach($product as $row): ?>
                <div class="col-sm-6 col-md-4 col-xl-3">
                    <a href="<?= site_url('admin/inventory/detail/'.$row->atk_product_id) ?>" class="text-decoration-none">
                        <div class="card h-100 shadow-sm hover-shadow border-0">
                            <div class="card-body d-flex flex-column justify-content-between">
                                <div class="d-flex align-items-center mb-3">
                                    <i class="fa fa-box fa-3x text-primary"></i>
                                    <div class="ms-3">
                                        <h6 class="fw-bold text-dark mb-1"><?= htmlspecialchars($row->atk_product_nama) ?></h6>
                                        
                                        <?php if ($row->atk_product_stok == 0): ?>
                                            <span class="badge bg-secondary">Stok Kosong</span>
                                        <?php elseif ($row->atk_product_stok < 5): ?>
                                            <span class="badge bg-danger">
                                                <?= htmlspecialchars($row->atk_product_stok) ?> <?= htmlspecialchars($row->uom_categories_nama) ?>
                                                (Hampir Habis!)
                                            </span>
                                        <?php else: ?>
                                            <span class="badge bg-success">
                                                <?= htmlspecialchars($row->atk_product_stok) ?> <?= htmlspecialchars($row->uom_categories_nama) ?>
                                            </span>
                                        <?php endif; ?>
                                    </div>
                                </div>
                                <small class="text-muted">Lokasi: <?= htmlspecialchars($row->inventory_location_nama) ?></small>
                            </div>
                        </div>
                    </a>
                </div>
            <?php endforeach; ?>
        <?php else: ?>
            <div class="col-12">
                <div class="alert alert-warning text-center">Belum ada produk tersedia.</div>
            </div>
        <?php endif; ?>
    </div>
</div>

<style>
.hover-shadow {
    cursor: pointer;
    transition: all 0.3s ease-in-out;
}
.hover-shadow:hover {
    transform: translateY(-5px);
    box-shadow: 0 10px 20px rgba(0,0,0,0.15);
}
.card .badge {
    font-size: 0.8rem;
}
</style>

<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">

