<div class="container-fluid pt-4 px-4">
    <div class="card shadow-lg border-0 rounded-3 mb-5">
        <div class="card-header bg-gradient-primary text-white py-3 d-flex justify-content-between align-items-center">
            <h5 class="mb-0 fw-bold">
                <i class="fa fa-chart-bar me-2"></i> Rekap Karyawan Pengambilan ATK
            </h5>
            <div>
                <a href="<?= site_url('Admin/Admin_Dashboard_Controller/export_excel?bulan='.$bulan.'&tahun='.$tahun) ?>" 
                   class="btn btn-success btn-sm me-2 shadow-sm">
                    <i class="fa fa-file-excel me-1"></i> Excel
                </a>
                <a href="<?= site_url('Admin/Admin_Dashboard_Controller/export_pdf?bulan='.$bulan.'&tahun='.$tahun) ?>" 
                   class="btn btn-danger btn-sm shadow-sm" target="_blank">
                    <i class="fa fa-file-pdf me-1"></i> PDF
                </a>
            </div>
        </div>
        <div class="card-body">

            <!-- Filter Form -->
            <form method="get" class="row g-3 mb-4">
                <div class="col-md-3">
                    <select name="bulan" class="form-select shadow-sm">
    <option value="all" <?= ($bulan=='all')?'selected':'' ?>>All Month</option>
    <?php 
                        
                        $nama_bulan = [
                            1=>"Januari",2=>"Februari",3=>"Maret",4=>"April",5=>"Mei",6=>"Juni",
                            7=>"Juli",8=>"Agustus",9=>"September",10=>"Oktober",11=>"November",12=>"Desember"
                        ];
                        for ($i=1;$i<=12;$i++): ?>
                            <option value="<?= $i ?>" <?= ($bulan==$i)?'selected':'' ?>>
                                <?= $nama_bulan[$i] ?>
                            </option>
                        <?php endfor; ?>
                    </select>
                </div>
                <div class="col-md-3">
                    <input type="number" name="tahun" class="form-control shadow-sm" value="<?= $tahun ?>" placeholder="Tahun">
                </div>
                <div class="col-md-2">
                    <button type="submit" class="btn btn-primary shadow-sm">
                        <i class="fa fa-filter me-1"></i> Filter
                    </button>
                </div>
            </form>

            <!-- Rekap Per Karyawan -->
            <h5 class="mb-3 text-primary fw-bold"><i class="fa fa-user me-2"></i> Rekap Per Karyawan</h5>
            <div class="table-responsive mb-5">
                <table class="table table-striped table-hover align-middle shadow-sm">
                    <thead class="table-primary">
                        <tr class="text-center">
                            <th>No</th>
                            <th>Nama Peminjam</th>
                            <th>Divisi</th>
                            <th>Total Transaksi</th>
                            <th>Total Item</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php 
                        $total_transaksi = 0;
                        $total_item = 0;
                        if(!empty($rekap)): 
                            $no=1; 
                            foreach($rekap as $r): 
                                $total_transaksi += $r->total_transaksi;
                                $total_item += $r->total_item;
                        ?>
                            <tr>
                                <td class="text-center"><?= $no++ ?></td>
                                <td class="text-center"><?= $r->atk_pengambilan_peminjam ?></td>
                                <td class="text-center"><?= $r->atk_pengambilan_divisi ?></td>
                                <td class="text-center"><?= $r->total_transaksi ?></td>
                                <td class="text-center"><?= $r->total_item ?></td>
                            </tr>
                        <?php endforeach; ?>
                            <tr class="table-info fw-bold text-center">
                                <td colspan="3">Total Keseluruhan</td>
                                <td><?= $total_transaksi ?></td>
                                <td><?= $total_item ?></td>
                            </tr>
                        <?php else: ?>
                            <tr>
                                <td colspan="5" class="text-center text-muted">Belum ada data</td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>

            <!-- Rekap Per Divisi -->
            <h5 class="mb-3 text-success fw-bold"><i class="fa fa-building me-2"></i> Rekap Per Divisi</h5>
            <div class="table-responsive">
                <table class="table table-striped table-hover align-middle shadow-sm">
                    <thead class="table-success">
                        <tr class="text-center">
                            <th>No</th>
                            <th>Divisi</th>
                            <th>Total Karyawan</th>
                            <th>Total Transaksi</th>
                            <th>Total Item</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php 
                        $total_karyawan_div = 0;
                        $total_transaksi_div = 0;
                        $total_item_div = 0;
                        if(!empty($rekap_divisi)): 
                            $no=1; 
                            foreach($rekap_divisi as $d): 
                                $total_karyawan_div += $d->total_karyawan;
                                $total_transaksi_div += $d->total_transaksi;
                                $total_item_div += $d->total_item;
                        ?>
                            <tr>
                                <td class="text-center"><?= $no++ ?></td>
                                <td class="text-center"><?= $d->atk_pengambilan_divisi ?></td>
                                <td class="text-center"><?= $d->total_karyawan ?></td>
                                <td class="text-center"><?= $d->total_transaksi ?></td>
                                <td class="text-center"><?= $d->total_item ?></td>
                            </tr>

                        <?php endforeach; ?>
                            <tr class="table-warning fw-bold text-center">
                                <td colspan="2">Total Keseluruhan</td>
                                <td><?= $total_karyawan_div ?></td>
                                <td><?= $total_transaksi_div ?></td>
                                <td><?= $total_item_div ?></td>
                            </tr>
                        <?php else: ?>
                            <tr>
                                <td colspan="5" class="text-center text-muted">Belum ada data</td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>

        </div>
    </div>
</div>
