<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Dashboard extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->library('session');
        $this->load->model('User_model');
        // Pastikan Tamu_model dimuat
        $this->load->model('Tamu_model'); 
        $this->load->model('Barang_masuk_model');
        $this->load->model('Barang_keluar_model');
        $this->load->helper('url');

        // cek login
        if (!$this->session->userdata('logged_in')) {
            redirect('login');
        }
    }

    
    public function index() {
        $data['username'] = $this->session->userdata('username');
        $data['total_admin'] = $this->User_model->count_admin();
    
        // ✅ PERBAIKAN: Hitung jumlah tamu hari ini menggunakan Model
        // Baris ini akan menjamin tamu dihitung hanya untuk tanggal saat ini.
        $data['total_tamu_hari_ini'] = $this->Tamu_model->count_today(); 

        // Hitung jumlah barang masuk
        $data['total_barang_masuk'] = $this->Barang_masuk_model->count_all();

        // Hitung jumlah barang keluar
        $data['total_barang_keluar'] = $this->Barang_keluar_model->count_all();

        $this->load->view('dashboard/index', $data);
    }


    // Fungsi user() tetap sama, hanya memuat Tamu_model di __construct()
    public function user() {
        $username = $this->session->userdata('username');
        $user_id  = $this->session->userdata('user_id');

        // Hitung jumlah tamu yang pernah diinput user ini
        $this->db->where('created_at', $user_id); // pastikan kolom created_by ada di tabel tamu
        $data['total_tamu_user'] = $this->db->count_all_results('tamu');

        // Ambil 5 tamu terakhir yang diinput user
        $this->db->where('created_at', $user_id);
        $this->db->order_by('waktu_masuk', 'DESC');
        $this->db->limit(5);
        $data['tamu_terakhir'] = $this->db->get('tamu')->result();

        $data['username'] = $username;

        $this->load->view('dashboard/dashboard_user', $data);
    }
}