<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Profile extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->model('User_model');
        $this->load->library('session');

        if (!$this->session->userdata('logged_in')) {
            redirect('auth/login');
        }
    }

    public function index() {
        $user_id = $this->session->userdata('user_id');
        $data['admin'] = $this->User_model->get_by_id($user_id);

        // kasih default foto kalau kosong
        if (empty($data['admin']->foto)) {
            $data['admin']->foto = 'default.png';
        }

        $this->load->view('profile/index', $data);
    }
}
