<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class User_model extends CI_Model {

    public function get_all_admin() {
        return $this->db->get('admin')->result();
    }

    public function login($username, $password) {
        // Cari user di tabel admin
        $this->db->where('username', $username);
        $user = $this->db->get('admin')->row();

        // Cek password
        if ($user && password_verify($password, $user->password)) {
            // kasih default foto kalau kosong
            if (empty($user->foto)) {
                $user->foto = 'default.png';
            }
            return $user;
        }

        return false;
    }

    public function get_admins_perbulan() {
        $this->db->where('role', 'admin');
        $this->db->where('MONTH(created_at)', date('m'));
        $this->db->where('YEAR(created_at)', date('Y'));
        return $this->db->get('admin')->result();
    }

    public function get_admins_perminggu() {
        $this->db->where('role', 'admin');
        $this->db->where('YEARWEEK(created_at, 1) = YEARWEEK(CURDATE(), 1)');
        return $this->db->get('admin')->result();
    }

    public function count_admin() {
        $this->db->where('role', 'admin'); 
        return $this->db->count_all_results('admin');
    }

    public function insert_admin($data) {
        return $this->db->insert('admin', $data);
    }

    public function get_by_id($id) {
        return $this->db->where('id', $id)->get('admin')->row();
    }
} 
