<!DOCTYPE html>
<html>
<head>
    <title>Master User</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <link rel="icon" href="<?= base_url('asset/img/asiaserv-logo.png') ?>" type="image/png">
    <style>
        body {
            background: #f4f7f9; /* Latar belakang lebih netral */
        }
        .page-header-custom {
            /* Menggunakan warna solid biru primer untuk kesan profesional */
            background-color: #0d6efd; 
            color: #fff;
            padding: 20px 30px;
            border-radius: 12px 12px 0 0;
        }
        .card {
            border-radius: 12px;
            box-shadow: 0 4px 12px rgba(0,0,0,0.08); /* Shadow yang lebih baik */
        }
        /* Style Tabel */
        .table-custom thead th {
            background-color: #0d6efd; /* Header tabel warna primer */
            color: white;
            font-weight: 600;
            vertical-align: middle;
        }
        .table-custom tbody tr:hover {
            background-color: #e9ecef;
            cursor: pointer;
        }
        .btn-action {
            padding: 6px 10px;
            border-radius: 8px; /* Sudut lebih kotak */
            font-size: 0.85rem;
            margin: 2px;
        }
    </style>
</head>
<body>
<div class="container-fluid mt-5 mb-5">
    <div class="card shadow-lg border-0">
        
        <div class="page-header-custom d-flex justify-content-between align-items-center">
            <h2 class="m-0"><i class="bi bi-people-fill me-2"></i> Master User Management</h2>
            <a href="<?= base_url('index.php/user_controller/add_admin') ?>" class="btn btn-light text-primary fw-bold px-3">
                <i class="bi bi-person-plus-fill me-1"></i> Add Admin
            </a>
        </div>

        <div class="card-body p-4">

            <div class="d-flex justify-content-between mb-4">
                 <a href="<?= base_url('index.php/dashboard') ?>" class="btn btn-outline-secondary px-3">
                    <i class="bi bi-arrow-left me-1"></i> Back to Dashboard
                </a>
                
                </div>
           
            <div class="table-responsive">
                <table class="table table-custom align-middle table-striped table-hover">
                    <thead class="table-dark">
                        <tr>
                            <th class="text-center">No</th>
                            <th>Username</th>
                            <th>Email</th>
                            <th>Role</th>
                            <th>Date Created</th>
                            <th class="text-center" style="width: 250px;">Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $no=1; foreach($users as $user): ?>
                        <tr>
                            <td class="text-center"><?= $no++ ?></td>
                            <td class="fw-bold"><?= $user->username ?></td>
                            <td><?= $user->email ?></td>
                            <td>
                                <?php if($user->role == 'admin'): ?>
                                    <span class="badge bg-danger rounded-pill"><i class="bi bi-person-fill-gear"></i> Admin</span>
                                <?php else: ?>
                                    <span class="badge bg-success rounded-pill"><i class="bi bi-person-fill"></i> User</span>
                                <?php endif; ?>
                            </td>
                            <td><?= date('d M Y, H:i', strtotime($user->created_at)) ?></td>
                            <td class="text-center">
                                <a href="<?= base_url('index.php/user_controller/profil/'.$user->id) ?>" class="btn btn-info btn-action text-white" data-bs-toggle="tooltip" title="Lihat Profil">
                                    <i class="bi bi-eye"></i> Profil
                                </a>
                                <a href="<?= base_url('index.php/user_controller/edit_profil/'.$user->id) ?>" class="btn btn-warning btn-action text-dark" data-bs-toggle="tooltip" title="Ubah Data">
                                    <i class="bi bi-pencil-square"></i> Edit
                                </a>
                                <button type="button" class="btn btn-danger btn-action" 
                                    onclick="confirmDelete('<?= base_url('index.php/user_controller/delete/'.$user->id) ?>', '<?= $user->username ?>')"
                                    data-bs-toggle="tooltip" title="Hapus User">
                                    <i class="bi bi-trash"></i> Delete
                                </button>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                        <?php if(empty($users)): ?>
                        <tr>
                            <td colspan="6" class="text-center text-muted py-4">
                                <i class="bi bi-exclamation-circle me-1"></i> User data is not yet available.
                            </td>
                        </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>

        </div>
    </div>
</div>

<script>
    // FUNGSI KONFIRMASI DELETE MENGGUNAKAN SWEETALERT2
    function confirmDelete(deleteUrl, username) {
        Swal.fire({
            title: 'Deletion Confirmation',
            html: `Are you sure you want to delete the user "${username}"?`,
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#dc3545', // Merah
            cancelButtonColor: '#6c757d', // Abu-abu
            confirmButtonText: 'Yes, Delete!',
            cancelButtonText: 'Cancel'
        }).then((result) => {
            if (result.isConfirmed) {
                window.location.href = deleteUrl;
            }
        });
    }

    // Mengaktifkan Tooltip Bootstrap
    var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'))
    var tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
      return new bootstrap.Tooltip(tooltipTriggerEl)
    })
</script>

<?php if($this->session->flashdata('success')): ?>
<script>
    Swal.fire({
        icon: 'success',
        title: 'success!',
        text: '<?= $this->session->flashdata('success'); ?>',
        timer: 3000,
        showConfirmButton: false
    });
</script>
<?php endif; ?>

<?php if($this->session->flashdata('error')): ?>
<script>
    Swal.fire({
        icon: 'error',
        title: 'Gagal!',
        text: '<?= $this->session->flashdata('error'); ?>',
        confirmButtonColor: '#dc3545'
    });
</script>
<?php endif; ?>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>