<!DOCTYPE html>
<html>
<head>
    <title>Tambah Admin</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
    <link rel="icon" href="<?= base_url('asset/img/asiaserv-logo.png') ?>" type="image/png">
    <style>
        body { background: #e9ecef; } /* Latar belakang abu-abu muda */
        .page-header { 
            background: linear-gradient(90deg, #0d6efd, #0dcaf0); 
            color: #fff; 
            padding: 20px; 
            border-radius: 12px 12px 0 0; /* Membuat sudut atas melengkung */
            margin-bottom: 0 !important;
        }
        .card-custom { 
            border-radius: 0 0 12px 12px; 
            border-top: none;
        }
        .form-control, .form-select { 
            border-radius: 8px; 
            box-shadow: none !important;
        }
        .btn { border-radius: 8px; }
        .text-error { color: #dc3545; font-size: 0.875em; } /* Warna error merah Bootstrap */
        .form-section-title {
            font-size: 1.15rem;
            color: #0d6efd;
            border-bottom: 2px solid #0d6efd;
            padding-bottom: 5px;
            margin-bottom: 20px;
        }
    </style>
</head>
<body>
<div class="container mt-5 mb-5">
    <div class="row justify-content-center">
        <div class="col-lg-9">

            <div class="page-header shadow-sm">
                <h2 class="m-0"><i class="bi bi-person-plus-fill me-2"></i> Tambah Akun Admin Baru</h2>
            </div>

            <div class="card card-custom shadow p-4 p-lg-5">
                <form action="<?= base_url('index.php/user_controller/save_admin') ?>" method="post" enctype="multipart/form-data">
                    
                    <div class="row">
                        
                        <div class="col-md-6 border-end pe-md-4">
                            <div class="form-section-title">Informasi Pribadi</div>

                            <div class="mb-3">
                                <label class="form-label fw-bold"><i class="bi bi-person-badge me-2"></i> Nama Lengkap</label>
                                <input type="text" name="nama_lengkap" class="form-control" placeholder="Masukkan nama lengkap" value="<?= set_value('nama_lengkap') ?>" required>
                                <small class="text-error"><?= form_error('nama_lengkap') ?></small>
                            </div>

                            <div class="mb-3">
                                <label class="form-label fw-bold"><i class="bi bi-briefcase me-2"></i> Jabatan/Job</label>
                                <input type="text" name="job" class="form-control" placeholder="Masukkan jabatan atau pekerjaan" value="<?= set_value('job') ?>" required>
                                <small class="text-error"><?= form_error('job') ?></small>
                            </div>

                            <div class="mb-3">
                                <label class="form-label fw-bold"><i class="bi bi-calendar-date me-2"></i> Tanggal Lahir</label>
                                <input type="date" name="dob" class="form-control" value="<?= set_value('dob') ?>" required>
                                <small class="text-error"><?= form_error('dob') ?></small>
                            </div>
                            
                             <div class="mb-3">
                                <label class="form-label fw-bold"><i class="bi bi-image me-2"></i> Foto Profil (Opsional)</label>
                                <input type="file" name="foto" class="form-control" accept="image/*">
                                <small class="text-muted">Max 2MB (jpg, png, gif)</small>
                            </div>

                        </div>

                        <div class="col-md-6 ps-md-4">
                            <div class="form-section-title">Informasi Akun & Akses</div>

                            <div class="mb-3">
                                <label class="form-label fw-bold"><i class="bi bi-person me-2"></i> Username</label>
                                <input type="text" name="username" class="form-control" placeholder="Masukkan username unik" value="<?= set_value('username') ?>" required>
                                <small class="text-error"><?= form_error('username') ?></small>
                            </div>

                            <div class="mb-3">
                                <label class="form-label fw-bold"><i class="bi bi-envelope me-2"></i> Email</label>
                                <input type="email" name="email" class="form-control" placeholder="Masukkan alamat email" value="<?= set_value('email') ?>" required>
                                <small class="text-error"><?= form_error('email') ?></small>
                            </div>

                            <div class="mb-3">
                                <label class="form-label fw-bold"><i class="bi bi-lock me-2"></i> Password</label>
                                <input type="password" name="password" class="form-control" placeholder="Minimal 6 karakter" required>
                                <small class="text-error"><?= form_error('password') ?></small>
                            </div>

                            <div class="mb-3">
                                <label class="form-label fw-bold"><i class="bi bi-person-check me-2"></i> Role Akses</label>
                                <select name="role" class="form-select" required>
                                    <option value="">-- Pilih Level Akses --</option>
                                    <option value="admin" <?= set_select('role','admin') ?>>Admin</option>
                                    <option value="user" <?= set_select('role','user') ?>>User</option>
                                </select>
                                <small class="text-error"><?= form_error('role') ?></small>
                            </div>

                        </div>
                    </div>
                    
                    <div class="d-flex justify-content-between mt-4 pt-4 border-top">
                        <a href="<?= base_url('index.php/user_controller') ?>" class="btn btn-outline-secondary px-4">
                            <i class="bi bi-arrow-left me-1"></i> Kembali ke Daftar
                        </a>
                        <button type="submit" class="btn btn-primary px-4 shadow-sm">
                            <i class="bi bi-save me-1"></i> Simpan Admin
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<?php if($this->session->flashdata('success')): ?>
<script>
Swal.fire({
    icon: 'success',
    title: 'Sukses',
    text: '<?= $this->session->flashdata('success'); ?>',
    confirmButtonColor: '#0d6efd'
});
</script>
<?php endif; ?>

<?php if($this->session->flashdata('error')): ?>
<script>
Swal.fire({
    icon: 'error',
    title: 'Gagal Menambah Admin',
    html: '<?= $this->session->flashdata('error'); ?>',
    confirmButtonColor: '#dc3545'
});
</script>
<?php endif; ?>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>