<!DOCTYPE html>
<html>
<head>
    <title>Laporan Admin</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="icon" href="<?= base_url('asset/img/asiaserv-logo.png') ?>" type="image/png">
</head>
<body class="container mt-4">

    <h2 class="mb-4">📊 Laporan Daftar Tamu</h2>

    <!-- Filter -->
    <form method="get" class="mb-3 d-flex gap-2">
        <select name="filter" class="form-select w-auto">
            <option value="">Semua</option>
            <option value="minggu" <?= ($this->input->get('filter') == 'minggu') ? 'selected' : '' ?>>Minggu ini</option>
            <option value="bulan" <?= ($this->input->get('filter') == 'bulan') ? 'selected' : '' ?>>Bulan ini</option>
        </select>
        <button type="submit" class="btn btn-primary">Terapkan</button>
        <a href="<?= base_url('Admin_Laporan_Controller') ?>" class="btn btn-secondary">Reset</a>
    </form>

    <!-- Tabel Tamu -->
    <div class="card shadow">
        <div class="card-body">
            <table class="table table-bordered table-striped">
                <thead class="table-dark">
                    <tr>
                        <th>No</th>
                        <th>Nama</th>
                        <th>Instansi</th>
                        <th>Keperluan</th>
                        <th>Waktu Masuk</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if(empty($tamu)): ?>
                        <tr><td colspan="5" class="text-center">Tidak ada data tamu</td></tr>
                    <?php else: ?>
                        <?php $no=1; foreach($tamu as $row): ?>
                        <tr>
                            <td><?= $no++ ?></td>
                            <td><?= $row->nama ?></td>
                            <td><?= $row->instansi ?></td>
                            <td><?= $row->keperluan ?></td>
                            <td><?= $row->waktu_masuk ?></td>
                        </tr>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>

    <a href="<?= site_url('dashboard/index') ?>" class="btn btn-secondary mt-3">⬅ Kembali ke Dashboard</a>



</body>
</html>
