<!DOCTYPE html>
<html lang="id">
<head>
    <title>Tambah Barang Keluar</title>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <link rel="icon" href="<?= base_url('asset/img/asiaserv-logo.png') ?>" type="image/png">
    <style>
        :root {
            --primary-color: #dc3545; /* Merah untuk Keluar/Out */
            --secondary-color: #6c757d;
            --bg-main: #f4f7f9;
        }
        body {
            background-color: var(--bg-main);
            font-family: 'Poppins', sans-serif;
            padding-top: 50px;
            padding-bottom: 50px;
        }
        .card-custom {
            border-radius: 18px;
            box-shadow: 0 8px 30px rgba(0,0,0,0.15);
            border: none;
            max-width: 800px;
            margin: auto;
        }
        .card-header-custom {
            background: linear-gradient(135deg, #dc3545, #fd7e14); /* Gradient Merah-Oranye */
            color: white;
            font-weight: 700;
            font-size: 1.5rem;
            border-top-left-radius: 18px;
            border-top-right-radius: 18px;
            padding: 25px 30px;
            display: flex;
            align-items: center;
        }
        .form-label {
            font-weight: 600;
            color: #495057;
        }
        .form-control {
            border-radius: 10px;
            box-shadow: 0 2px 5px rgba(0,0,0,0.05);
            transition: all 0.2s;
        }
        .form-control:focus {
            border-color: var(--primary-color);
            box-shadow: 0 0 0 0.25rem rgba(220, 53, 69, 0.25);
        }
        .btn-action {
            border-radius: 12px;
            min-width: 150px;
            font-weight: 600;
            padding: 10px 20px;
        }
        .btn-primary-custom {
            background-color: var(--primary-color);
            border-color: var(--primary-color);
            transition: all 0.3s;
        }
        .btn-primary-custom:hover {
            background-color: #c82333;
            border-color: #c82333;
            transform: translateY(-2px);
            box-shadow: 0 4px 10px rgba(220, 53, 69, 0.3);
        }
        .form-section-title {
            font-size: 1.1rem;
            color: var(--primary-color);
            font-weight: 600;
            margin-top: 25px;
            margin-bottom: 15px;
            padding-bottom: 5px;
            border-bottom: 2px solid #f8d7da; /* Warna border halus */
        }
    </style>
</head>
<body>

<div class="container">
    <div class="card card-custom">
        <div class="card-header-custom">
            <i class="bi bi-box-arrow-up-right me-2"></i> Form Tambah Barang Keluar
        </div>

        <div class="card-body p-4 p-md-5">

            <?= validation_errors('<div class="alert alert-danger"><i class="bi bi-exclamation-triangle-fill me-2"></i>','</div>'); ?>

            <form id="formBarangKeluar" action="<?= site_url('barang_keluar_controller/store') ?>" method="post" enctype="multipart/form-data">
                
                <div class="form-section-title"><i class="bi bi-box me-2"></i> Detail Barang</div>
                <div class="row g-4">
                    <div class="col-md-6">
                        <label class="form-label">Jenis Barang</label>
                        <input type="text" name="jenis_barang" class="form-control" placeholder="Cth: Dokumen Penting / Peralatan" required>
                    </div>
                    <div class="col-md-6">
                        <label class="form-label">Jumlah</label>
                        <input type="number" name="jumlah" class="form-control" placeholder="Cth: 1 (Satuan)" required>
                    </div>
                    <div class="col-12">
                        <label class="form-label">Tujuan Pengiriman</label>
                        <input type="text" name="tujuan" class="form-control" placeholder="Alamat atau lokasi tujuan barang" required>
                    </div>
                </div>

                <div class="form-section-title"><i class="bi bi-people me-2"></i> Penanggung Jawab & Waktu</div>
                <div class="row g-4">
                    <div class="col-md-6">
                        <label class="form-label">PIC (Person In Charge)</label>
                        <input type="text" name="pic" class="form-control" placeholder="Nama staf yang mengeluarkan barang" required>
                    </div>
                    <div class="col-md-6">
    <label class="form-label">Driver / Kurir</label>
    <input type="text" name="driver" class="form-control" placeholder="Nama pengantar barang" required>
</div>

<!-- Tambahan: Origin -->
<div class="col-md-6">
    <label class="form-label">Origin (Asal Barang)</label>
    <select name="origin" class="form-control" required>
        <option value="">-- Pilih Origin --</option>
        <option value="Arkadia Head Office">Arkadia Head Office</option>
        <option value="Workshop BSD">Workshop BSD</option>
    </select>
</div>

                    <div class="col-md-6">
                        <label class="form-label">Tanggal Keluar</label>
                        <input type="date" name="tanggal" class="form-control" value="<?= date('Y-m-d') ?>" required>
                    </div>
                    <div class="col-md-6">
                        <label class="form-label">Waktu Keluar</label>
                        <input type="time" name="waktu_keluar" class="form-control" value="<?= date('H:i') ?>" required>
                    </div>
                </div>

                <div class="form-section-title"><i class="bi bi-camera me-2"></i> Dokumentasi</div>
                <div class="mb-3">
                    <label class="form-label">Upload Foto Barang</label>
                    <input type="file" name="foto" class="form-control" accept="image/*">
                    <small class="text-muted">Ambil foto barang sebagai bukti pengeluaran.</small>
                </div>

                <div class="d-flex justify-content-end gap-3 mt-4">
                    <a href="<?= site_url('barang_keluar_controller') ?>" class="btn btn-secondary btn-action">
                        <i class="bi bi-arrow-left me-1"></i> Kembali
                    </a>
                    <button type="button" id="btnSave" class="btn btn-primary btn-primary-custom btn-action">
                        <i class="bi bi-box-arrow-up-right me-1"></i> Simpan Data
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

<script>
document.getElementById("btnSave").addEventListener("click", function(){
    // Tambahkan validasi sederhana sebelum SweetAlert
    const form = document.getElementById('formBarangKeluar');
    if (!form.checkValidity()) {
        form.reportValidity(); // Tampilkan pesan error default browser
        return;
    }

    Swal.fire({
        title: 'Konfirmasi Simpan Data?',
        text: "Pastikan semua data sudah benar sebelum barang dikeluarkan.",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#dc3545', /* Warna Merah */
        cancelButtonColor: '#6c757d',
        confirmButtonText: 'Ya, Simpan!',
        cancelButtonText: 'Batal'
    }).then((result) => {
        if (result.isConfirmed) {
            Swal.fire({
                title: 'Memproses...',
                text: 'Mohon tunggu sebentar',
                allowOutsideClick: false,
                didOpen: () => {
                    Swal.showLoading()
                }
            });
            form.submit();
        }
    });
});
</script>

<?php if(isset($this->session) && $this->session->flashdata('success')): ?>
<script>
    Swal.fire({
        icon: 'success',
        title: 'Sukses!',
        text: '<?= $this->session->flashdata('success'); ?>',
        showConfirmButton: false,
        timer: 2000,
        position: 'center'
    });
</script>
<?php endif; ?>

</body>
</html>