<!DOCTYPE html>
<html>
<head>
    <title><?= isset($barang) ? 'Edit' : 'Add' ?> Outgoing Item</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <link rel="icon" href="<?= base_url('asset/img/asiaserv-logo.png') ?>" type="image/png">
    <style>
        body {
            background-color: #f4f7f9;
            font-family: 'Poppins', sans-serif;
        }
        .card-custom {
            max-width: 750px;
            margin: 50px auto;
            border-radius: 18px;
            box-shadow: 0 10px 30px rgba(0,0,0,0.15);
        }
        .card-header-custom {
            background: linear-gradient(90deg, #dc3545, #ff5f6d);
            color: white;
            border-top-left-radius: 18px;
            border-top-right-radius: 18px;
            padding: 25px;
        }
        .form-label {
            font-weight: 600;
            color: #495057;
        }
        .form-control {
            border-radius: 10px;
            box-shadow: none !important;
            border-color: #ced4da;
        }
        .img-preview {
            border: 2px solid #dc3545;
            border-radius: 10px;
            padding: 5px;
            max-width: 150px;
            height: auto;
            object-fit: cover;
        }
        .btn-action {
            border-radius: 10px;
            min-width: 120px;
            font-weight: 600;
        }
    </style>
</head>
<body class="bg-light">
<div class="container mt-5 mb-5">
    <div class="card card-custom border-0">
        
        <div class="card-header-custom text-center">
            <h3 class="mb-0">
                <i class="bi bi-box-arrow-up-right me-2"></i> 
                <?= isset($barang) ? 'EDIT' : 'ADD' ?> OUTGOING ITEM
            </h3>
        </div> 

        <div class="card-body p-4 p-md-5">
            
            <?php echo validation_errors('<div class="alert alert-danger mb-4"><i class="bi bi-x-octagon-fill me-2"></i>','</div>'); ?>

            <form id="formBarangKeluar" 
                  action="<?= isset($barang) ? site_url('barang_keluar_controller/update/'.$barang->id) : site_url('barang_keluar_controller/store') ?>" 
                  method="post" enctype="multipart/form-data">

                <div class="row g-4">
                    
                    <div class="col-12">
                        <h5 class="text-danger mb-3 pb-2 border-bottom border-danger opacity-75">
                            <i class="bi bi-box me-2"></i> Item Information
                        </h5>
                    </div>
                    
                    <div class="col-md-6">
                        <label class="form-label">Item Type <span class="text-danger">*</span></label>
                        <input type="text" name="jenis_barang" class="form-control" placeholder="Example: Document, Product A"
                                value="<?= isset($barang) ? $barang->jenis_barang : '' ?>" required>
                    </div>
                    
                    <div class="col-md-6">
                        <label class="form-label">Quantity <span class="text-danger">*</span></label>
                        <input type="number" name="jumlah" class="form-control" placeholder="Enter item quantity"
                                value="<?= isset($barang) ? $barang->jumlah : '' ?>" required>
                    </div>
                    
                    <div class="col-12 mt-4">
                        <h5 class="text-danger mb-3 pb-2 border-bottom border-danger opacity-75">
                            <i class="bi bi-truck me-2"></i> Logistics & Destination
                        </h5>
                    </div>
                    
                    <div class="col-md-4">
                        <label class="form-label">PIC <span class="text-danger">*</span></label>
                        <input type="text" name="pic" class="form-control" placeholder="Internal PIC Name"
                                value="<?= isset($barang) ? $barang->pic : '' ?>" required>
                    </div>

                    <div class="col-md-4">
                        <label class="form-label">Driver / Courier <span class="text-danger">*</span></label>
                        <input type="text" name="driver" class="form-control" placeholder="External Driver/Courier Name"
                                value="<?= isset($barang) ? $barang->driver : '' ?>" required>
                    </div>

                    <div class="col-md-4">
                        <label class="form-label">Origin <span class="text-danger">*</span></label>
                        <select name="origin" class="form-control" required>
                            <option value="">-- Select Origin --</option>
                            <option value="Arkadia Head Office" 
                                <?= isset($barang) && $barang->origin == 'Arkadia Head Office' ? 'selected' : '' ?>>
                                Arkadia Head Office
                            </option>
                            <option value="Workshop BSD" 
                                <?= isset($barang) && $barang->origin == 'Workshop BSD' ? 'selected' : '' ?>>
                                Workshop BSD
                            </option>
                        </select>
                    </div>

                    
                    <div class="col-md-6">
                        <label class="form-label">Destination <span class="text-danger">*</span></label>
                        <input type="text" name="tujuan" class="form-control" placeholder="Shipping Destination Location"
                                value="<?= isset($barang) ? $barang->tujuan : '' ?>" required>
                    </div>
                    
                    <div class="col-md-6">
                        <label class="form-label">Date Out <span class="text-danger">*</span></label>
                        <input type="date" name="tanggal" class="form-control" 
                                value="<?= isset($barang) ? $barang->tanggal : date('Y-m-d') ?>" required>
                    </div>
                    
                    <div class="col-md-6">
                        <label class="form-label">Time Out <span class="text-danger">*</span></label>
                        <input type="time" name="waktu_keluar" class="form-control" id="waktu_keluar" 
                                value="<?= isset($barang) ? $barang->waktu_keluar : '' ?>" required>
                    </div>

                    <div class="col-12 mt-4">
                        <h5 class="text-danger mb-3 pb-2 border-bottom border-danger opacity-75">
                            <i class="bi bi-camera me-2"></i> Photo Proof
                        </h5>
                        
                        <label class="form-label">Upload Item Photo</label>
                        <input type="file" name="foto" class="form-control" accept="image/*">
                        <small class="text-muted">Select a new photo if you wish to change it.</small>
                        
                        <?php if (isset($barang) && !empty($barang->foto)): ?>
                            <div class="mt-3">
                                <p class="mb-2 fw-bold text-danger">Current Photo:</p>
                                <img src="<?= base_url('uploads/'.$barang->foto) ?>" 
                                        alt="Outgoing Item Photo" class="img-preview shadow-sm">
                            </div>
                        <?php endif; ?>
                    </div>

                </div>

                <div class="d-flex justify-content-between mt-5 pt-3 border-top">
                    <a href="<?= site_url('barang_keluar_controller/list_admin') ?>" class="btn btn-outline-secondary btn-action">
                        <i class="bi bi-arrow-left-circle me-1"></i> Back
                    </a>
                    <button type="button" id="btnSubmit" class="btn btn-danger btn-action">
                        <i class="bi bi-check-circle-fill me-1"></i> 
                        <?= isset($barang) ? 'Update Data' : 'Save Data' ?>
                    </button>
                </div>
            </form>

        </div>
    </div>
</div>

<script src="https://code.jquery.com/jquery-3.7.0.min.js"></script>
<script>
$(document).ready(function(){
    // Set exit time automatically if it's a new form
    const waktuInput = document.getElementById('waktu_keluar');
    if (!waktuInput.value) {
        const now = new Date();
        const h = String(now.getHours()).padStart(2,'0');
        const m = String(now.getMinutes()).padStart(2,'0');
        waktuInput.value = `${h}:${m}`;
    }

    // SweetAlert Confirmation before submit
    $('#btnSubmit').on('click', function(e){
        e.preventDefault();
        
        const isEdit = <?= isset($barang) ? 'true' : 'false' ?>;
        const titleText = isEdit ? 'Confirm Changes?' : 'Save Outgoing Item Data?'; // Terjemahan: Konfirmasi Perubahan? / Simpan Data Barang Keluar?
        const confirmText = isEdit ? 'Yes, Update!' : 'Yes, Save!'; // Terjemahan: Ya, Update! / Ya, Simpan!
        
        Swal.fire({
            title: titleText,
            text: "Ensure all data has been filled correctly.", // Terjemahan: Pastikan semua data sudah terisi dengan benar.
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#dc3545', 
            cancelButtonColor: '#6c757d',
            confirmButtonText: confirmText,
            cancelButtonText: 'Cancel' // Terjemahan: Batal
        }).then((result) => {
            if (result.isConfirmed) {
                Swal.fire({
                    title: 'Processing...', // Terjemahan: Memproses...
                    text: 'Please wait a moment.', // Terjemahan: Mohon tunggu sebentar.
                    allowOutsideClick: false,
                    didOpen: () => {
                        Swal.showLoading();
                    } 
                });
                $('#formBarangKeluar').submit();
            }
        });
    });
});
</script>

<?php if($this->session->flashdata('success')): ?>
<script>
Swal.fire({
    icon: 'success',
    title: 'Success!', // Terjemahan: Berhasil!
    text: '<?= $this->session->flashdata('success'); ?>',
    showConfirmButton: false,
    timer: 2000
});
</script>
<?php endif; ?>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>