<!DOCTYPE html>
<html>
<head>
    <title>Outgoing Items - Admin</title>
    <meta charset="UTF-8"> 
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/dataTables.bootstrap5.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.min.css">
    <link rel="icon" href="<?= base_url('asset/img/asiaserv-logo.png') ?>" type="image/png">

    <style>
        :root {
            --primary-color: #dc3545;
            --primary-dark: #a71d2a;
            --bg-main: #f5f7fa;
            --shadow-lg: 0 1rem 3rem rgba(0,0,0,.175);
        }
         .container-fluid {
    max-width: 98%; /* biar tidak full mentok */
}

.table-responsive {
    overflow-x: auto;
    min-width: 1500px;
}

.table {
    width: 100% !important;
    table-layout: auto !important;
}

        body {
            background-color: var(--bg-main);
            font-family: 'Poppins', sans-serif;
        }

        .card-floating {
            border-radius: 20px;
            box-shadow: var(--shadow-lg);
            border: none;
            overflow: hidden;
        }

        .card-header-title {
            font-size: 1.4rem;
            font-weight: 700;
            display: flex;
            align-items: center;
            gap: 10px;
            padding: 20px 30px;
            color: #fff;
            background: linear-gradient(135deg, var(--primary-dark), var(--primary-color));
            box-shadow: 0 5px 15px rgba(220, 53, 69, 0.5);
            margin: -20px -20px 20px -20px;
        }

        .filters-container {
            border-radius: 12px !important;
            padding: 15px 20px !important;
            box-shadow: inset 0 1px 3px rgba(0,0,0,0.05);
        }

        .table thead th {
            background: var(--primary-color);
            color: #fff;
            text-align: center !important;
            vertical-align: middle;
            white-space: nowrap;
            padding: 15px 10px;
            font-weight: 600;
        }

        .table tbody td {
            text-align: center !important;
            vertical-align: middle;
            font-size: 0.95rem;
            padding: 12px 8px;
        }

        .photo-thumbnail {
            width: 50px;
            height: 50px;
            object-fit: cover;
            border-radius: 10px;
            border: 2px solid #ddd;
            transition: transform 0.3s ease, border-color 0.3s ease;
            cursor: pointer;
        }

        .photo-thumbnail:hover {
            transform: scale(1.1);
            border-color: var(--primary-color);
        }

        #modalFoto {
            max-width: 100%;
            height: auto;
            max-height: 70vh;
            border-radius: 10px;
            border: 3px solid #fff;
        }
        
        /* Peningkatan Tombol Export */
        .btn-export-custom {
            font-weight: 600 !important;
            transition: all 0.2s ease;
            box-shadow: 0 4px 6px rgba(0,0,0,0.1);
        }
        .btn-export-custom:hover {
            transform: translateY(-1px);
            box-shadow: 0 6px 8px rgba(0,0,0,0.15);
        }
        .btn-close-white {
            filter: invert(1);
        }
        /* PERBESAR FONT ISI TABEL KESELURUHAN */
#barangKeluarTable th,
#barangKeluarTable td {
    font-size: 20px !important;   /* kamu bisa naikkan lagi jadi 16 kalau mau lebih besar */
}

#barangKeluarTable td span.badge {
    font-size: 14px !important;
}

#barangKeluarTable .btn {
    font-size: 13px !important;
    padding: 7px 12px !important;
}

    </style>
</head>
<body>
<div class="container-fluid mt-5 mb-5">

    <?php if($this->session->flashdata('success')): ?>
    <div class="alert alert-success alert-dismissible fade show card-floating shadow-sm" role="alert">
        <i class="fa fa-check-circle me-1"></i> <?= $this->session->flashdata('success') ?>
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>
    <?php endif; ?>

    <div class="card card-floating shadow-lg">
        <div class="card-body p-4">
            <div class="d-flex justify-content-between align-items-center flex-wrap">
                <div class="card-header-title">
                    <i class="fa fa-box-open"></i> Outgoing Goods List
                </div>

                <div class="header-actions d-flex gap-2 mb-3 mb-md-0">
                    <a href="<?= site_url('barang_keluar_controller/create_admin') ?>" class="btn btn-danger btn-export-custom px-4 py-2">
                        <i class="fa fa-plus me-1"></i> Add Goods
                    </a>
                    <button id="exportExcel" class="btn btn-success btn-export-custom px-4 py-2">
                        <i class="fa fa-file-excel me-1"></i> Export Excel
                    </button>
                    <button id="exportPDF" class="btn btn-info btn-export-custom text-white px-4 py-2">
                        <i class="fa fa-file-pdf me-1"></i> Export PDF
                    </button>
                </div>
            </div>

            <div class="filters-container d-flex flex-wrap justify-content-start align-items-center gap-3 mb-4 mt-4 bg-light">
                <input type="text" id="filterPIC" class="form-control" style="max-width: 250px;" placeholder="Search PIC/Driver/Destination">
                <input type="date" id="filterTanggal" class="form-control" style="max-width: 150px;">
                <button id="clearFilter" class="btn btn-sm btn-outline-danger">
                    <i class="fa fa-rotate-right"></i> Reset Filter
                </button>
            </div>

            <div class="table-responsive">
                <table class="table table-striped table-bordered align-middle mb-0" id="barangKeluarTable">
                    <thead>
                        <tr>
                            <th>No</th>
                            <th>PIC</th>
                            <th>Item Type</th>
                            <th>Count</th>                          
                            <th>From</th>
                            <th>Destination</th>
                            <th>Date</th>
                            <th>Time Out</th>
                            <th>Photo</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if(!empty($barang_keluar)): ?>
                            <?php $no=1; foreach($barang_keluar as $b): ?>
                            <tr>
                                <td><?= $no++ ?></td>
                                <td><?= htmlspecialchars($b->pic) ?></td>
                                <td><?= htmlspecialchars($b->jenis_barang) ?></td>
                                <td><?= htmlspecialchars($b->jumlah) ?></td>                              
                                <td><?= htmlspecialchars($b->origin) ?></td>                               
                                <td><?= htmlspecialchars($b->tujuan) ?></td>
                                <td data-order="<?= date('Y-m-d', strtotime($b->tanggal)) ?>">
                                    <span class="badge bg-danger"><?= date('d-m-Y', strtotime($b->tanggal)) ?></span>
                                </td>
                                <td data-order="<?= date('H:i', strtotime($b->waktu_keluar)) ?>"><?= date('H:i', strtotime($b->waktu_keluar)) ?></td>
                                <td>
                                    <?php if($b->foto): ?>
                                        <img src="<?= base_url('uploads/'.$b->foto) ?>" 
                                            class="photo-thumbnail" 
                                            data-bs-toggle="modal" 
                                            data-bs-target="#fotoModal" 
                                            onclick="showFoto('<?= base_url('uploads/'.$b->foto) ?>', '<?= htmlspecialchars($b->foto) ?>')">
                                    <?php else: ?>
                                        <span class="badge bg-secondary"><i class="fa fa-camera-slash"></i> No Photo</span>
                                    <?php endif; ?>
                                </td>
                                <td>
    <a href="<?= site_url('barang_keluar_controller/edit_admin/'.$b->id) ?>" 
       class="btn btn-warning btn-sm">
       <i class="fa fa-edit"></i> Edit
    </a>

    <a href="#" 
       class="btn btn-danger btn-sm btnDelete" 
       data-id="<?= $b->id ?>">
       <i class="fa fa-trash"></i> Delete
    </a>
</td>

                            </tr>
                            <?php endforeach; ?>
                        <?php else: ?>
                            <tr><td colspan="10" class="text-center text-muted py-3">No outgoing goods data available.</td></tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
 
            <div class="d-flex justify-content-between align-items-center mt-4">
                <a href="<?= site_url('dashboard'); ?>" class="btn btn-outline-secondary">
                    <i class="fa fa-arrow-left me-2"></i> Kembali ke Dashboard
                </a>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="fotoModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-lg">
        <div class="modal-content">
            <div class="modal-header bg-danger text-white">
                <h5 class="modal-title"><i class="fa fa-image me-2"></i> Item Photo View</h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body text-center py-4">
                <img id="modalFoto" src="" class="img-fluid" alt="Preview">
            </div>
            <div class="modal-footer justify-content-between">
                <span id="fileNameDisplay" class="text-muted small"></span>
                <a id="downloadFoto" href="#" download class="btn btn-primary">
                    <i class="fa fa-download me-2"></i> Download Photo
                </a>
            </div>
        </div>
    </div>
</div>

<script src="https://code.jquery.com/jquery-3.7.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/dataTables.bootstrap5.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script>
$(document).ready(function () {
    var t = $('#barangKeluarTable').DataTable({
        pageLength: 10,
        lengthChange: false,
        ordering: true,
        order: [[6, 'desc']],
        dom: 'lrtip'
    });

    $('#filterPIC').on('keyup', function () {
        t.search(this.value).draw();
    });

    $.fn.dataTable.ext.search.push(function(settings, data, dataIndex) {
        var filterTanggal = $('#filterTanggal').val();
        if (!filterTanggal) return true;
        // Kolom 6 adalah Date
        var rowTanggal = $(t.row(dataIndex).node()).find('td[data-order]').eq(0).attr('data-order');
        return rowTanggal === filterTanggal;
    });

    $('#filterTanggal').on('change', function() {
        t.draw();
    });

    $('#clearFilter').on('click', function () {
        $('#filterPIC').val('');
        $('#filterTanggal').val('');
        t.search('').draw();
        t.draw();
    });

    // FUNGSI PERBAIKAN: Menampilkan foto, nama file, dan link download
    window.showFoto = function(src, fileName) {
        $('#modalFoto').attr('src', src);
        $('#downloadFoto').attr('href', src);
        $('#downloadFoto').attr('download', fileName);
        $('#fileNameDisplay').text('File: ' + fileName);
    };

    $('.btnDelete').on('click', function(e) {
        e.preventDefault();
        const id = $(this).data('id');
        Swal.fire({
            title: 'Hapus Data Ini?',
            text: "Tindakan ini tidak dapat dibatalkan!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#dc3545',
            cancelButtonColor: '#6c757d',
            confirmButtonText: 'Ya, hapus!'
        }).then((result) => {
            if (result.isConfirmed) {
                window.location.href = '<?= site_url("barang_keluar_controller/delete/") ?>' + id;
            }
        });
    });

    // Fungsi Export
    $('#exportExcel').on('click', function() {
        var search = $('#filterPIC').val();
        var tanggal = $('#filterTanggal').val();
        window.location.href = '<?= site_url("barang_keluar_controller/export_excel") ?>?search=' + encodeURIComponent(search) + '&tanggal=' + tanggal;
    });

    $('#exportPDF').on('click', function() {
        var search = $('#filterPIC').val();
        var tanggal = $('#filterTanggal').val();
        window.location.href = '<?= site_url("barang_keluar_controller/export_pdf") ?>?search=' + encodeURIComponent(search) + '&tanggal=' + tanggal;
    });
});
</script>
</body>
</html>