<!DOCTYPE html>
<html lang="id">
<head>
    <title>Edit Barang Masuk</title>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <link rel="icon" href="<?= base_url('asset/img/asiaserv-logo.png') ?>" type="image/png">
    <style>
        :root {
            --primary-color: #0d6efd;
            --secondary-color: #6c757d;
            --bg-main: #f4f7f9;
        }
        body {
            background-color: var(--bg-main);
            font-family: 'Poppins', sans-serif;
            padding-top: 40px;
            padding-bottom: 40px;
        }
        .card-custom {
            max-width: 800px;
            margin: auto;
            border-radius: 18px;
            box-shadow: 0 10px 30px rgba(0,0,0,0.15);
            border: none;
        }
        .card-header-custom {
            background: linear-gradient(90deg, #0d6efd, #0dcaf0);
            color: white;
            font-weight: 700;
            font-size: 1.5rem;
            border-top-left-radius: 18px;
            border-top-right-radius: 18px;
            padding: 25px 30px;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        .form-label {
            font-weight: 600;
            color: #495057;
        }
        .form-control, .form-select {
            border-radius: 10px;
            box-shadow: 0 2px 5px rgba(0,0,0,0.05);
            transition: all 0.2s;
        }
        .form-control:focus, .form-select:focus {
            border-color: #0dcaf0;
            box-shadow: 0 0 0 0.25rem rgba(13, 110, 253, 0.25);
        }
        .form-section-title {
            font-size: 1.1rem;
            color: var(--primary-color);
            font-weight: 600;
            margin-top: 25px;
            margin-bottom: 15px;
            padding-bottom: 5px;
            border-bottom: 2px solid #e9ecef;
        }
        .btn-action {
            border-radius: 12px;
            min-width: 150px;
            font-weight: 600;
            padding: 10px 20px;
            transition: all 0.3s;
        }
        .current-photo {
            max-width: 120px;
            height: auto;
            border-radius: 8px;
            border: 2px solid #dee2e6;
            padding: 5px;
            box-shadow: 0 2px 8px rgba(0,0,0,0.1);
        }
    </style>
</head>
<body>

<div class="container">
    <div class="card card-custom">
        <div class="card-header-custom">
            <h5 class="mb-0"><i class="bi bi-pencil-square me-2"></i> Edit Data Barang Masuk</h5>
            <span class="badge bg-light text-primary fs-6">ID: <?= $barang->id ?></span>
        </div>

        <form id="editForm" action="<?= site_url('barang_masuk_controller/update/'.$barang->id) ?>" method="post" enctype="multipart/form-data">
            <div class="card-body p-4 p-md-5">
                <div class="form-section-title"><i class="bi bi-info-circle me-2"></i> Informasi Utama</div>
                <div class="row g-4">
                    <div class="col-md-6">
                        <label class="form-label"><i class="bi bi-person me-1"></i> Nama Pengirim</label>
                        <input type="text" name="nama_pengirim" value="<?= htmlspecialchars($barang->nama_pengirim) ?>" class="form-control" required>
                    </div>
                    <div class="col-md-6">
                        <label class="form-label"><i class="bi bi-building me-1"></i> Nama Vendor</label>
                        <input type="text" name="nama_vendor" value="<?= htmlspecialchars($barang->nama_vendor) ?>" class="form-control" required>
                    </div>
                    <div class="col-md-6">
                        <label class="form-label"><i class="bi bi-hash me-1"></i> No Registrasi</label>
                        <input type="text" name="no_registrasi" value="<?= htmlspecialchars($barang->no_registrasi) ?>" class="form-control" required>
                    </div>
                    <div class="col-md-6">
                        <label class="form-label"><i class="bi bi-box me-1"></i> Jenis Barang</label>
                        <input type="text" name="jenis_barang" value="<?= htmlspecialchars($barang->jenis_barang) ?>" class="form-control" required>
                    </div>
                </div>

                <div class="form-section-title"><i class="bi bi-people me-2"></i> Penanggung Jawab & Lokasi</div>
                <div class="row g-4">
                    <div class="col-md-6">
                        <label class="form-label"><i class="bi bi-person-check me-1"></i> Penerima</label>
                        <input type="text" name="penerima" value="<?= htmlspecialchars($barang->penerima) ?>" class="form-control" required>
                    </div>
                    <div class="col-md-6">
                        <label class="form-label"><i class="bi bi-shield-lock me-1"></i> Security</label>
                        <input type="text" name="security" value="<?= htmlspecialchars($barang->security) ?>" class="form-control" Readonly >
                    </div>
                    <div class="col-md-6">
                        <label class="form-label"><i class="bi bi-geo-alt me-1"></i> Lokasi</label>
                        <select name="location" class="form-select" required>
                            <option value="">-- Pilih Lokasi --</option>
                            <option value="Arkadia Head Office" <?= ($barang->location == 'Arkadia Head Office') ? 'selected' : '' ?>>Arkadia Head Office</option>
                            <option value="Workshop BSD" <?= ($barang->location == 'Workshop BSD') ? 'selected' : '' ?>>Workshop BSD</option>
                        </select>
                    </div>
                    <div class="col-md-6">
                        <label class="form-label"><i class="bi bi-calendar-date me-1"></i> Tanggal Masuk</label>
                        <input type="date" name="tanggal" value="<?= htmlspecialchars($barang->tanggal) ?>" class="form-control" required>
                    </div>
                    <div class="col-md-6">
                        <label class="form-label"><i class="bi bi-clock me-1"></i> Waktu Masuk</label>
                        <input type="time" name="waktu_masuk" value="<?= htmlspecialchars($barang->waktu_masuk) ?>" class="form-control" required>
                    </div>
                </div>

                <div class="form-section-title"><i class="bi bi-camera me-2"></i> Dokumentasi Foto</div>
                <div class="mb-3">
                    <label class="form-label">Ganti Foto Barang</label>
                    <input type="file" name="foto" class="form-control" accept="image/*">
                    <small class="text-muted">Kosongkan jika tidak ingin mengganti foto.</small>

                    <?php if($barang->foto && file_exists(FCPATH.'uploads/barang/'.$barang->foto)): ?>
                        <div class="mt-3">
                            <p class="mb-1 fw-bold text-primary">Foto Saat Ini:</p>
                            <img src="<?= base_url('uploads/barang/'.$barang->foto) ?>" alt="Foto Barang Saat Ini" class="current-photo">
                        </div>
                    <?php endif; ?>
                </div>
            </div>

            <div class="card-footer bg-light d-flex justify-content-end gap-3 p-4">
                <a href="<?= site_url('barang_masuk_controller') ?>" class="btn btn-outline-secondary btn-action">
                    <i class="bi bi-arrow-left me-1"></i> Kembali
                </a>
                <button type="button" id="btnSave" class="btn btn-primary btn-action">
                    <i class="bi bi-save me-1"></i> Simpan Perubahan
                </button>
            </div>
        </form>
    </div>
</div>

<script>
document.getElementById("btnSave").addEventListener("click", function(){
    const form = document.getElementById('editForm');
    if (!form.checkValidity()) {
        form.reportValidity();
        return;
    }

    Swal.fire({
        title: 'Konfirmasi Perubahan Data?',
        text: "Data barang masuk akan diperbarui ke sistem.",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#0d6efd',
        cancelButtonColor: '#6c757d',
        confirmButtonText: 'Ya, Simpan Perubahan!',
        cancelButtonText: 'Batal'
    }).then((result) => {
        if (result.isConfirmed) {
            Swal.fire({
                title: 'Menyimpan...',
                text: 'Mohon tunggu sebentar',
                allowOutsideClick: false,
                didOpen: () => Swal.showLoading()
            });
            form.submit();
        }
    });
});
</script>

<?php if(isset($this->session) && $this->session->flashdata('success')): ?>
<script>
Swal.fire({ 
    icon: 'success',
    title: 'Berhasil!',
    text: '<?= $this->session->flashdata('success'); ?>',
    showConfirmButton: false,
    timer: 1800
});
</script>
<?php endif; ?>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
