<!DOCTYPE html>
<html>
<head>
    <title>Edit Incoming Goods (Admin)</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <link rel="icon" href="<?= base_url('asset/img/asiaserv-logo.png') ?>" type="image/png">
    <style>
        body {
            background-color: #f4f7f9;
            font-family: 'Poppins', sans-serif;
        }
        .card-custom {
            max-width: 850px;
            margin: 40px auto;
            border-radius: 18px;
            box-shadow: 0 10px 30px rgba(0,0,0,0.15);
        }
        .card-header-custom {
            background: linear-gradient(90deg, #0d6efd, #0dcaf0);
            color: white;
            border-top-left-radius: 18px;
            border-top-right-radius: 18px;
            padding: 20px;
        }
        .form-label {
            font-weight: 600;
            color: #495057;
        }
        .form-control, .form-select {
            border-radius: 10px;
            box-shadow: none !important;
        }
        .form-section-title {
            font-size: 1.1rem;
            color: #0d6efd;
            font-weight: 600;
            margin-bottom: 20px;
            padding-bottom: 5px;
            border-bottom: 1px dashed #ced4da;
        }
        .photo-preview {
            border: 2px solid #ccc;
            border-radius: 10px;
            padding: 5px;
            max-width: 150px;
            display: block;
            object-fit: cover;
        }
        .btn-action {
            border-radius: 10px;
            min-width: 150px;
            font-weight: 600;
        }
        .card-footer {
            padding: 20px 25px;
            background-color: #fff;
            border-bottom-left-radius: 18px;
            border-bottom-right-radius: 18px;
        }
    </style>
</head>
<body>

<div class="container">
    <div class="card card-custom border-0">
        <div class="card-header-custom d-flex align-items-center justify-content-between">
            <h4 class="mb-0"><i class="bi bi-pencil-square me-2"></i> Edit Incoming Goods Data</h4>
            <span class="badge bg-light text-primary fs-6">ID: <?= $barang->id ?></span>
        </div>

        <form id="editForm" action="<?= site_url('barang_masuk_controller/update_admin/'.$barang->id) ?>" 
              method="post" enctype="multipart/form-data">
            
            <div class="card-body p-4 p-md-5">
                <div class="row g-4">
                    
                    <div class="col-md-6 pe-md-4 border-end">
                        <div class="form-section-title"><i class="bi bi-box me-2"></i> Item Details</div>

                        <div class="mb-3">
                            <label class="form-label">Item Type</label>
                            <input type="text" name="jenis_barang" value="<?= $barang->jenis_barang ?>" class="form-control" required>
                        </div>
                        
                        <div class="mb-3">
                            <label class="form-label">Registration No.</label>
                            <input type="text" name="no_registrasi" value="<?= $barang->no_registrasi ?>" class="form-control" required>
                        </div>

                        <div class="mb-3">
                            <label class="form-label">Sender's Name</label>
                            <input type="text" name="nama_pengirim" value="<?= $barang->nama_pengirim ?>" class="form-control" required>
                        </div>
                        
                        <div class="mb-3">
                            <label class="form-label">Vendor / Courier Name</label>
                            <input type="text" name="nama_vendor" value="<?= $barang->nama_vendor ?>" class="form-control" required>
                        </div>
                    </div>
                    
                    <div class="col-md-6 ps-md-4">
                        <div class="form-section-title"><i class="bi bi-person-check me-2"></i> Acceptance Details</div>

                        <div class="mb-3">
                            <label class="form-label">Internal Recipient</label>
                            <input type="text" name="penerima" value="<?= $barang->penerima ?>" class="form-control" required>
                        </div>
                        
                        <div class="mb-3">
                            <label class="form-label">Security Officer</label>
                            <input type="text" name="security" value="<?= $barang->security ?>" class="form-control" Readonly >
                        </div>

                        <div class="mb-3">
                            <label class="form-label">Location</label>
                            <select name="location" class="form-select" required>
                                <option value="">-- Select Location --</option>
                                <option value="Arkadia Head Office" <?= ($barang->location == 'Arkadia Head Office') ? 'selected' : '' ?>>Arkadia Head Office</option>
                                <option value="Workshop BSD" <?= ($barang->location == 'Workshop BSD') ? 'selected' : '' ?>>Workshop BSD</option>
                            </select>
                        </div>

                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Date Received</label>
                                <input type="date" name="tanggal" value="<?= $barang->tanggal ?>" class="form-control" required>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Time Received</label>
                                <input type="time" name="waktu_masuk" value="<?= $barang->waktu_masuk ?>" class="form-control" required>
                            </div>
                        </div>

                        <div class="mb-3">
                            <label class="form-label"><i class="bi bi-image me-1"></i> Current Item Photo</label>
                            <?php if($barang->foto): ?>
                                <div class="mb-2">
                                    <img src="<?= base_url('uploads/barang/'.$barang->foto) ?>" alt="Item Photo" class="photo-preview">
                                </div>
                                <small class="text-info d-block mb-2">Current photo: <?= $barang->foto ?></small>
                            <?php else: ?>
                                <small class="text-warning d-block mb-2">No photo has been uploaded.</small>
                            <?php endif; ?>
                            
                            <label class="form-label mt-2">Change New Photo</label>
                            <input type="file" name="foto" class="form-control" accept="image/*">
                            <small class="text-muted">Leave blank if you don't want to change the photo.</small>
                        </div>
                    </div>
                </div>
            </div> 

            <div class="card-footer d-flex justify-content-between">
                <a href="<?= site_url('barang_masuk_controller/list_admin') ?>" class="btn btn-outline-secondary btn-action">
                    <i class="bi bi-arrow-left me-1"></i> Back
                </a>
                <button type="button" id="btnSave" class="btn btn-primary btn-action">
                    <i class="bi bi-save me-1"></i> Save Changes
                </button>
            </div>
        </form>
    </div>
</div>

<script>
document.getElementById("btnSave").addEventListener("click", function(){
    Swal.fire({
        title: 'Confirm Changes',
        html: "Are you sure you want to save the changes to this incoming goods data?",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#0d6efd',
        cancelButtonColor: '#6c757d',
        confirmButtonText: 'Yes, Save!',
        cancelButtonText: 'Cancel'
    }).then((result) => {
        if (result.isConfirmed) {
            Swal.fire({
                title: 'Processing...',
                text: 'Please wait a moment.',
                allowOutsideClick: false,
                didOpen: () => Swal.showLoading()
            });
            document.getElementById("editForm").submit();
        }
    });
});
</script>

<?php if($this->session->flashdata('success')): ?>
<script>
Swal.fire({
    icon: 'success',
    title: 'Success!',
    text: '<?= $this->session->flashdata('success'); ?>',
    showConfirmButton: false,
    timer: 2000
}); 
</script>
<?php endif; ?>

<?php if($this->session->flashdata('error')): ?>
<script>
Swal.fire({
    icon: 'error',
    title: 'Failed!',
    text: '<?= $this->session->flashdata('error'); ?>',
    confirmButtonColor: '#dc3545'
});
</script>
<?php endif; ?>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>