<!DOCTYPE html>
<html lang="id">
<head>
    <title>Tambah Barang Masuk</title>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <link rel="icon" href="<?= base_url('asset/img/asiaserv-logo.png') ?>" type="image/png">
    <style>
        :root {
            --primary-color: #0d6efd;
            --secondary-color: #6c757d;
            --bg-main: #f4f7f9;
        }
        body {
            background-color: var(--bg-main);
            font-family: 'Poppins', sans-serif;
        }
        .card-form {
            max-width: 800px;
            margin: 50px auto;
            border-radius: 18px;
            box-shadow: 0 8px 30px rgba(0,0,0,0.1);
            background-color: #fff;
            padding: 40px;
        }
        .card-form h3 {
            margin-bottom: 30px;
            text-align: center;
            font-weight: 700;
            color: var(--primary-color);
        }
        .form-label {
            font-weight: 600;
            color: #495057;
        }
        input.form-control, select.form-select {
            border-radius: 10px;
            box-shadow: 0 2px 5px rgba(0,0,0,0.05);
            transition: all 0.2s;
        }
        input.form-control:focus, select.form-select:focus {
            border-color: var(--primary-color);
            box-shadow: 0 0 0 0.25rem rgba(13, 110, 253, 0.25);
        }
        .btn-action {
            border-radius: 12px;
            min-width: 150px;
            font-weight: 600;
            padding: 10px 20px;
        }
        .btn-group-action {
            display: flex;
            justify-content: flex-end;
            gap: 15px;
            margin-top: 30px;
            padding-top: 20px;
            border-top: 1px solid #e9ecef;
        }
        .form-section-title {
            font-size: 1.1rem;
            color: var(--primary-color);
            font-weight: 600;
            margin-top: 25px;
            margin-bottom: 15px;
            padding-bottom: 5px;
            border-bottom: 2px solid #e9ecef;
        }
    </style>
</head>
<body>
<div class="container">
    <div class="card-form">
        <h3><i class="bi bi-box-arrow-in-down me-2"></i> Form Input Barang Masuk</h3>
        
        <?php if (isset($this->session) && $this->session->flashdata('error')): ?>
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                <i class="bi bi-exclamation-triangle-fill me-2"></i> <?= $this->session->flashdata('error'); ?>
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
        <?php endif; ?>

        <form id="formTambah" method="post" enctype="multipart/form-data"
              action="<?= base_url('index.php/barang_masuk_controller/simpan') ?>">

            <div class="form-section-title"><i class="bi bi-truck me-2"></i> Detail Pengiriman</div>
            <div class="row g-3">
                <div class="col-md-6">
                    <label class="form-label">Nama Pengirim</label>
                    <input type="text" name="nama_pengirim" class="form-control" placeholder="Cth: PT Logistik Cepat" required>
                </div>
                <div class="col-md-6">
                    <label class="form-label">Nama Vendor</label>
                    <input type="text" name="nama_vendor" class="form-control" placeholder="Vendor yang dituju" required>
                </div>
                <div class="col-md-6">
                    <label class="form-label">No Registrasi/Surat Jalan</label>
                    <input type="text" name="no_registrasi" class="form-control" placeholder="Nomor dokumen registrasi" required>
                </div>
                <div class="col-md-6">
                    <label class="form-label">Jenis Barang</label>
                    <input type="text" name="jenis_barang" class="form-control" placeholder="Cth: Dokumen, Mesin, Paket" required>
                </div>
                <div class="col-md-6">
                    <label class="form-label">Penerima Internal</label>
                    <input type="text" name="penerima" class="form-control" placeholder="Nama staf penerima barang" required>
                </div>
                <div class="mb-3">
    <label class="form-label">Security</label>
    <input type="text" name="security" class="form-control" 
           value="<?= $this->session->userdata('nama_lengkap'); ?>" 
           readonly required>
</div>
                <!-- ✅ Tambahan kolom lokasi -->
                <div class="col-md-6">
                    <label class="form-label"><i class="bi bi-geo-alt me-1"></i> Lokasi</label>
                    <select name="location" class="form-select" required>
                        <option value="">-- Pilih Lokasi --</option>
                        <option value="Arkadia Head Office">Arkadia Head Office</option>
                        <option value="Workshop BSD">Workshop BSD</option>
                    </select>
                </div>
            </div>

            <div class="form-section-title"><i class="bi bi-calendar-check me-2"></i> Waktu dan Dokumentasi</div>
            <div class="row g-3">
                <div class="col-md-6">
                    <label class="form-label">Tanggal Masuk</label>
                    <input type="date" name="tanggal" class="form-control" value="<?= date('Y-m-d') ?>" required>
                </div>
                <div class="col-md-6">
                    <label class="form-label">Waktu Masuk</label>
                    <input type="time" name="waktu_masuk" class="form-control" value="<?= date('H:i') ?>" required>
                </div>
                <div class="col-12">
                    <label class="form-label"><i class="bi bi-camera me-1"></i> Upload Foto Barang (Bukti)</label>
                    <input type="file" name="foto" class="form-control" accept="image/*">
                    <small class="text-muted">Format: JPG, PNG. Ukuran maksimal 2MB.</small>
                </div>
            </div>

            <div class="btn-group-action">
                <a href="<?= base_url('index.php/barang_masuk_controller') ?>" class="btn btn-outline-secondary btn-action">
                    <i class="bi bi-arrow-left me-1"></i> Kembali
                </a>
                <button type="button" id="btnSave" class="btn btn-primary btn-action">
                    <i class="bi bi-save me-1"></i> Simpan Data
                </button>
            </div>
        </form>
    </div>
</div>

<script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

<script>
document.getElementById("btnSave").addEventListener("click", function(){
    const form = document.getElementById('formTambah');
    if (!form.checkValidity()) {
        form.reportValidity();
        return;
    }

    Swal.fire({
        title: 'Konfirmasi Penyimpanan',
        text: "Anda yakin data barang masuk ini sudah lengkap dan benar?",
        icon: 'question',
        showCancelButton: true,
        confirmButtonColor: '#0d6efd',
        cancelButtonColor: '#6c757d',
        confirmButtonText: 'Ya, Simpan',
        cancelButtonText: 'Batal'
    }).then((result) => {
        if (result.isConfirmed) {
            Swal.fire({
                title: 'Menyimpan...',
                text: 'Mohon tunggu sebentar',
                allowOutsideClick: false,
                didOpen: () => Swal.showLoading()
            });
            form.submit();
        }
    });
});

<?php if(isset($this->session) && $this->session->flashdata('success')): ?>
Swal.fire({
    icon: 'success',
    title: 'Berhasil!',
    text: '<?= $this->session->flashdata('success'); ?>',
    showConfirmButton: false,
    timer: 1800
});
<?php endif; ?>
</script>
</body>
</html>
