<!DOCTYPE html>
<html>
<head>
    <title>Add Incoming Goods (Admin)</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
    <script src="https://code.jquery.com/jquery-3.7.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <link rel="icon" href="<?= base_url('asset/img/asiaserv-logo.png') ?>" type="image/png">
    <style>
        body {
            background-color: #e9ecef;
            font-family: 'Poppins', sans-serif;
        }
        .card-form { 
            max-width: 850px; 
            margin: 40px auto;
            padding: 40px;
            border-radius: 18px;
            box-shadow: 0 10px 30px rgba(0,0,0,0.15);
            background-color: #fff;
        }
        .form-header {
            border-bottom: 3px solid #0d6efd;
            padding-bottom: 15px;
            margin-bottom: 30px;
        }
        .form-section-title {
            font-size: 1.1rem;
            color: #0d6efd;
            font-weight: 600;
            margin-bottom: 20px;
            padding-bottom: 5px;
            border-bottom: 1px dashed #ced4da;
        }
        .form-label {
            font-weight: 600;
            color: #495057;
        }
        .form-control, .form-select {
            border-radius: 10px;
            box-shadow: none !important;
        }
        .btn-action {
            border-radius: 10px;
            min-width: 130px;
            font-weight: 600;
        }
        .btn-group-action {
            display: flex;
            justify-content: flex-end;
            gap: 10px;
            margin-top: 30px;
            padding-top: 20px;
            border-top: 1px solid #eee;
        }
    </style>
</head>
<body>
<div class="container">
    <div class="card-form">
        <div class="form-header text-center">
            <h2 class="mb-0 text-primary"><i class="bi bi-box-arrow-in-down me-2"></i> Add Incoming Goods</h2>
            <p class="text-muted mt-1 mb-0">Input logistics data and acceptance of new goods.</p>
        </div>

        <form id="formBarangMasuk" method="post" action="<?= base_url('index.php/barang_masuk_controller/simpan_admin') ?>" enctype="multipart/form-data">
            
            <div class="row">
                
                <div class="col-md-6 pe-md-4 border-end">
                    <div class="form-section-title"><i class="bi bi-box me-2"></i> Item Details</div>
                    
                    <div class="mb-3">
                        <label class="form-label">Item Type</label>
                        <input type="text" name="jenis_barang" class="form-control" placeholder="Example: Document Package, Sparepart" required>
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label">Registration No.</label>
                        <input type="text" name="no_registrasi" class="form-control" placeholder="Consignment note or item registration number" required>
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label">Sender's Name</label>
                        <input type="text" name="nama_pengirim" class="form-control" placeholder="Name of the party sending the goods" required>
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label">Vendor / Courier Name</label>
                        <input type="text" name="nama_vendor" class="form-control" placeholder="Example: JNE, DHL, PT. Supplier A" required>
                    </div>
                </div>

                <div class="col-md-6 ps-md-4">
                    <div class="form-section-title"><i class="bi bi-calendar-check me-2"></i> Acceptance Details</div>

                    <div class="mb-3">
                        <label class="form-label">Internal Recipient</label>
                        <input type="text" name="penerima" class="form-control" placeholder="Name of the employee/division addressed" required>
                    </div>
                    
                    <div class="mb-3">
    <label class="form-label">Security Officer</label>
    <input type="text" name="security" class="form-control" 
           value="<?= $this->session->userdata('nama_lengkap'); ?>" 
           readonly required>
</div>

                    <div class="mb-3">
                        <label class="form-label">Location</label>
                        <select name="location" class="form-select" required>
                            <option value="">-- Select Location --</option>
                            <option value="Arkadia Head Office">Arkadia Head Office</option>
                            <option value="Workshop BSD">Workshop BSD</option>
                        </select>
                    </div>

                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label class="form-label">Date Received</label>
                            <input type="date" name="tanggal" class="form-control" required>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label">Time Received</label>
                            <input type="time" name="waktu_masuk" class="form-control" required>
                        </div>
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label"><i class="bi bi-camera me-1"></i> Item Photo (Optional)</label>
                        <input type="file" name="foto" class="form-control" accept="image/*">
                        <small class="text-muted">Upload photo proof of the item upon receipt.</small>
                    </div>
                </div>
            </div>

            <div class="btn-group-action">
                <a href="<?= base_url('index.php/barang_masuk_controller/list_admin') ?>" class="btn btn-outline-secondary btn-action">
                    <i class="bi bi-arrow-left me-1"></i> Back
                </a>
                <button type="submit" class="btn btn-primary btn-action">
                    <i class="bi bi-save me-1"></i> Save Data
                </button> 
            </div>
        </form>
    </div>
</div>

<script>
$(document).ready(function(){
    const now = new Date();
    const formattedDate = now.toISOString().substring(0, 10);
    const formattedTime = now.toTimeString().substring(0, 5);
    
    $('input[name="tanggal"]').val(formattedDate);
    $('input[name="waktu_masuk"]').val(formattedTime);

    $('#formBarangMasuk').on('submit', function(e){
        e.preventDefault();

        Swal.fire({
            title: 'Confirm Submission',
            html: "Are you sure this incoming goods data is correct and complete?",
            icon: 'question',
            showCancelButton: true,
            confirmButtonText: 'Yes, Save!',
            cancelButtonText: 'Cancel',
            confirmButtonColor: '#0d6efd',
            cancelButtonColor: '#6c757d',
            reverseButtons: true
        }).then((result) => {
            if (result.isConfirmed) {
                Swal.fire({
                    title: 'Processing...',
                    text: 'Please wait a moment.',
                    allowOutsideClick: false,
                    didOpen: () => {
                        Swal.showLoading();
                    } 
                });
                this.submit();
            }
        });
    });
});
</script>
</body>
</html>