<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Incoming Goods Data</title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600;700&display=swap" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/dataTables.bootstrap5.min.css">
    <link rel="icon" href="<?= base_url('asset/img/asiaserv-logo.png') ?>" type="image/png">
 
    <style>
        :root {
            --primary-color: #007bff; /* Biru Primer */
            --primary-dark: #0056b3;
            --secondary-color: #6c757d; 
            --bg-main: #f5f7fa; /* Latar belakang lembut */
            --card-shadow: 0 8px 25px rgba(0,0,0,0.1);
        }
        
        .container-fluid {
    max-width: 98%; /* biar tidak full mentok */
}

.table-responsive {
    overflow-x: auto;
    min-width: 1500px;
}

.table {
    width: 100% !important;
    table-layout: auto !important;
}


        body {
            background-color: var(--bg-main);
            font-family: 'Poppins', sans-serif;
            color: #343a40;
        }

        .main-card {
            background-color: #fff;
            border-radius: 15px; /* Sudut lebih lembut */
            box-shadow: var(--card-shadow);
            margin-top: 30px;
            overflow: hidden;
        }

        .card-header-custom {
            background: linear-gradient(90deg, var(--primary-dark), var(--primary-color));
            color: #fff;
            padding: 20px 30px;
            border-bottom: none;
            box-shadow: 0 4px 10px rgba(0, 123, 255, 0.4);
            margin-bottom: 0;
            display: flex;
            align-items: center;
        }

        h3 {
            font-weight: 700;
            font-size: 1.5rem;
            margin: 0;
        }

        .btn-add {
            font-weight: 600;
            border-radius: 50px; /* Lebih rounded */
            padding: 8px 20px;
        }

        /* Toolbar/Filter Styles */
        .filters-toolbar {
            padding: 15px 30px;
            background-color: #f8f9fa;
            border-bottom: 1px solid #e9ecef;
            display: flex;
            justify-content: space-between;
            align-items: center;
            flex-wrap: wrap;
            gap: 10px;
        }

        .form-control, .btn {
            border-radius: 8px;
            font-size: 0.95rem;
        }

        /* Table Styles */
        .table thead th {
            background-color: var(--primary-dark); /* Header lebih gelap */
            color: white;
            text-align: center !important; 
            vertical-align: middle;
            font-weight: 600;
            padding: 12px 8px;
            white-space: nowrap;
        }
        
        .table tbody td {
            text-align: center !important; 
            vertical-align: middle;
            font-size: 0.9rem;
            padding: 10px 8px;
            white-space: nowrap;
        }
        
        .table-striped > tbody > tr:nth-of-type(odd) > * {
            background-color: rgba(0, 123, 255, 0.03); /* Garis strip biru muda */
        }
        .table-hover tbody tr:hover {
            background-color: rgba(0, 123, 255, 0.1);
            cursor: default;
        }

        /* Photo Style */
        .foto-barang {
            width: 55px; 
            height: 55px;
            object-fit: cover;
            border-radius: 8px;
            border: 3px solid transparent;
            transition: border-color .3s, transform .3s;
        }
        .foto-barang:hover {
            transform: scale(1.1);
            border-color: #ffc107; /* Kuning/Warning untuk hover foto */
        }

        /* Action Buttons */
        .action-btns .btn {
            padding: 6px 10px;
        }

        .card-footer-custom {
            background: var(--bg-main);
            border-top: 1px solid #dee2e6;
            padding: 15px 30px;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        /* Datatables Pagination Customization */
        .dataTables_wrapper .dataTables_paginate .paginate_button.current, 
        .dataTables_wrapper .dataTables_paginate .paginate_button.current:hover {
            background-color: var(--primary-color) !important;
            border-color: var(--primary-color) !important;
            color: white !important;
            border-radius: 8px;
        }
    </style>
</head>
<body class="p-4">
<div class="container-fluid">
    
    <?php if(isset($this->session) && $this->session->flashdata('success')): ?>
    <div class="alert alert-success alert-dismissible fade show shadow-sm" role="alert">
        <i class="fa fa-check-circle me-1"></i> <?= $this->session->flashdata('success') ?>
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>
    <?php endif; ?>

    <div class="main-card">
        <div class="card-header-custom d-flex justify-content-between align-items-center">
            <h3><i class="fa fa-boxes me-2"></i>Incoming Goods Data</h3>
            <a href="<?= site_url('barang_masuk_controller/form_admin') ?>" class="btn btn-light btn-add shadow-sm">
                <i class="fa fa-plus me-1"></i> Add Item
            </a>
        </div>
        
        <div class="filters-toolbar">
            <div class="filters-group d-flex gap-3 flex-wrap">
                <input type="text" id="searchInput" class="form-control" style="max-width: 300px;" placeholder="Search Sender / Vendor Name">
                <input type="date" id="filterTanggal" class="form-control" style="max-width: 150px;" title="Filter by Date">
                <button id="clearFilter" class="btn btn-outline-secondary shadow-sm">
                    <i class="fa fa-sync-alt"></i> Reset
                </button>
            </div>
            <div class="filters-group d-flex gap-2">
                <button id="exportExcel" class="btn btn-success shadow-sm">
                    <i class="fa fa-file-excel"></i> Export Excel
                </button>
                <button id="exportPDF" class="btn btn-danger shadow-sm">
                    <i class="fa fa-file-pdf"></i> Export PDF
                </button>
            </div>
        </div>

        <div class="card-body p-0">
            <div class="table-responsive">
                <table class="table table-bordered table-striped table-hover mb-0" id="barangTable">
                    <thead>
                        <tr>
                            <th style="width: 5%;">No</th>
                            <th>Sender Name</th>
                            <th>Vendor Name</th>
                            <th>No Registration</th>
                            <th>Item Type</th>
                            <th>Receiver</th>
                            <th>Security</th>
                             <th>Location</th>
                            <th style="width: 10%;">Date</th>
                            <th style="width: 8%;">Time in</th>
                            <th style="width: 8%;">Photo</th>
                            <th style="width: 10%;" data-orderable="false">Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $no = 1; foreach($barang_masuk as $b): ?>
                        <tr>
                            <td><?= $no++ ?></td>
                            <td class="text-start fw-medium"><?= htmlspecialchars($b->nama_pengirim) ?></td>
                            <td class="text-start"><?= htmlspecialchars($b->nama_vendor) ?></td>
                            <td><?= htmlspecialchars($b->no_registrasi) ?></td>
                            <td><span class="badge bg-primary px-2 py-1"><?= htmlspecialchars($b->jenis_barang) ?></span></td>
                            <td><?= htmlspecialchars($b->penerima) ?></td>
                            <td><?= htmlspecialchars($b->security) ?></td>
                             <td>
            <?php if ($b->location == 'Arkadia Head Office'): ?>
                <span class="badge bg-info"><?= $b->location ?></span>
            <?php elseif ($b->location == 'Workshop BSD'): ?>
                <span class="badge bg-success"><?= $b->location ?></span>
            <?php else: ?>
                <span class="badge bg-secondary">Unknown</span>
            <?php endif; ?>
        </td>
                            <td data-order="<?= $b->tanggal ?>"><span class="badge bg-secondary"><?= date('d-m-Y', strtotime($b->tanggal)) ?></span></td>
                            <td><?= date('H:i', strtotime($b->waktu_masuk)) ?></td>
                            <td>
                                <?php if($b->foto): ?>
                                    <img src="<?= base_url('uploads/barang/'.$b->foto) ?>" alt="Foto Barang" class="foto-barang" 
                                         data-bs-toggle="modal" data-bs-target="#fotoModal" data-src="<?= base_url('uploads/barang/'.$b->foto) ?>">
                                <?php else: ?>
                                    <span class="badge bg-danger"><i class="fa fa-camera-slash"></i></span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <div class="d-flex justify-content-center gap-2 action-btns">
                                    <a href="<?= site_url('barang_masuk_controller/edit_admin/'.$b->id) ?>" class="btn btn-warning btn-sm" title="Edit Data">
                                        <i class="fa fa-edit"></i>
                                    </a>
                                    <button class="btn btn-danger btn-sm btnDelete" data-url="<?= site_url('barang_masuk_controller/delete_admin/'.$b->id) ?>" title="Delete data">
                                        <i class="fa fa-trash"></i>
                                    </button>
                                </div>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
        
        <div class="card-footer-custom">
            <a href="<?= site_url('dashboard') ?>" class="btn btn-outline-secondary btn-rounded">
                <i class="fa fa-arrow-left me-1"></i> Back to Dashboard
            </a>
            <div id="pagination-controls" class="d-flex gap-3 align-items-center">
                <div id="barangTable_info" class="dataTables_info"></div>
                <div id="barangTable_paginate" class="dataTables_paginate paging_simple_numbers"></div>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="fotoModal" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered modal-lg">
    <div class="modal-content">
      <div class="modal-header bg-primary text-white">
        <h5 class="modal-title"><i class="fa fa-image me-1"></i> Item Photo Preview</h5>
        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body text-center p-4">
        <img id="previewFoto" src="" class="img-fluid rounded shadow-lg mb-3" alt="Photo item">
        <br>
        <a id="downloadFotoBtn" href="#" class="btn btn-success" download>
          <i class="fa fa-download me-1"></i> Download Photo
        </a>
      </div>
    </div>
  </div>
</div>


<script src="https://code.jquery.com/jquery-3.7.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.all.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/dataTables.bootstrap5.min.js"></script>

<script>
$(document).ready(function () {
    // Inisialisasi DataTable
    var table = $('#barangTable').DataTable({
        "pageLength": 10, 
        "lengthChange": false,
        "ordering": true,
        "order": [[8, 'desc']], // Urut berdasarkan Date (kolom 7) DESC
        "language": {
            "paginate": { "previous": "« Prev", "next": "Next »" },
            "info": "Showing _START_ to _END_ of _TOTAL_ entries",
            "zeroRecords": "No data found",
            "infoEmpty": "Showing 0 to 0 of 0 entries",
            "infoFiltered": "(filtered from _MAX_ total entries)"
        },
        "dom": 'lrtip', // Hilangkan fitur search bawaan DataTables
        "columnDefs": [
            { "orderable": false, "targets": [0, 9, 10] } // Kolom No, Foto, dan Aksi tidak dapat diurutkan
        ]
    });

    // Pindahkan DataTables Info dan Pagination ke div custom di footer
    $('#barangTable_info').appendTo('#pagination-controls');
    $('#barangTable_paginate').appendTo('#pagination-controls');

    // --- Penanganan Nomor Urut Otomatis pada DataTable ---
    table.on('order.dt search.dt', function () {
        let i = 1;
        table.cells(null, 0, { search: 'applied', order: 'applied' }).every(function () { 
            this.data(i++); 
        });
    }).draw();

    // Search Pengirim/Vendor (Menggunakan search global)
    $('#searchInput').on('keyup', function () {
        table.search(this.value).draw();
    });

    // Filter tanggal (Kolom 7: Date)
    $.fn.dataTable.ext.search.push(function(settings, data, dataIndex) {
    var filterTanggal = $('#filterTanggal').val();
    if (!filterTanggal) return true;

    // Ambil data dari atribut data-order (karena berformat YYYY-MM-DD)
    var rowTanggal = $('td:eq(8)', table.row(dataIndex).node()).data('order'); 
    
    return rowTanggal === filterTanggal;
});

    
    $('#filterTanggal').on('change', function () {
        table.draw();
    });

    // Reset filter
    $('#clearFilter').on('click', function () {
        $('#searchInput').val('');
        $('#filterTanggal').val('');
        table.search('').draw(); // Reset search global dan draw ulang
    });

    // Modal preview foto
    $('#fotoModal').on('show.bs.modal', function (event) {
        var img = $(event.relatedTarget);
        var src = img.data('src');
        $('#previewFoto').attr('src', src);
    });

    // SweetAlert2 delete confirmation
    document.querySelectorAll('.btnDelete').forEach(btn => {
        btn.addEventListener('click', function(e){
            e.preventDefault();
            const url = this.dataset.url;
            Swal.fire({
                title: 'Are you sure?',
                text: "You won't be able to revert this!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#d33',
                cancelButtonColor: '#6c757d',
                confirmButtonText: 'Yes, delete it!',
                cancelButtonText: 'Cancel'
            }).then((result) => {
                if (result.isConfirmed) {
                    window.location.href = url;
                }
            });
        });
    });

    // Fungsi untuk mendapatkan filter saat ini untuk Export
    function getFilters() {
        return {
            search: $('#searchInput').val(),
            tanggal: $('#filterTanggal').val()
        };
    } 

    // Export Excel
    $('#exportExcel').on('click', function() {
        var filters = getFilters();
        var url = '<?= site_url("barang_masuk_controller/export_excel") ?>?search=' + encodeURIComponent(filters.search) + '&tanggal=' + filters.tanggal;
        window.location.href = url;
    });

    // Export PDF
    $('#exportPDF').on('click', function() {
        var filters = getFilters();
        var url = '<?= site_url("barang_masuk_controller/export_pdf") ?>?search=' + encodeURIComponent(filters.search) + '&tanggal=' + filters.tanggal;
        window.location.href = url;
    });
});
</script>
</body>
</html>