<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Laporan Data Barang Masuk</title>
    <style>
        body {
            font-family: 'Arial', sans-serif;
            font-size: 10pt;
            margin: 0;
            padding: 0;
            background-color: #f8f9fa;
        }

        .container {
            padding: 20px 40px;
            text-align: center;
        }

        .header-container {
            position: relative;
            border-bottom: 3px solid #003366;
            padding-bottom: 15px;
            margin-bottom: 25px;
        }

        .logo-left {
            position: absolute;
            left: 0;
            top: 0;
            max-height: 60px;
        }

        .title-block {
            text-align: center;
        }

        .title-block h1 {
            color: #003366;
            margin: 0;
            font-size: 18pt;
            text-transform: uppercase;
            font-weight: bold;
            letter-spacing: 1px;
        }

        .title-block p {
            margin: 3px 0;
            font-size: 10pt;
            color: #555;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 10px;
            font-size: 9pt;
            text-align: center;
        }

        th, td {
            border: 1px solid #b0b0b0;
            padding: 6px;
            vertical-align: middle;
        }

        th {
            background-color: #003366;
            color: #ffffff;
            font-weight: bold;
            text-transform: uppercase;
        }

        .foto img {
            max-width: 55px;
            max-height: 55px;
            object-fit: cover;
            border-radius: 5px;
            border: 1px solid #ccc;
        }

        .footer {
            margin-top: 40px;
            font-size: 9pt;
            color: #666;
            text-align: center;
            border-top: 1px solid #ccc;
            padding-top: 10px;
        }
    </style>
</head>
<body>

<?php 
date_default_timezone_set('Asia/Jakarta');
$username = $this->session->userdata('nama_lengkap') ??
            $this->session->userdata('username') ??
            'Tidak diketahui';

// LOGO BASE64
$logoPath = FCPATH . 'asset/img/asiaserv-logo.png';
$logoBase64 = '';

if (file_exists($logoPath)) {
    $logoBase64 = 'data:image/png;base64,' . base64_encode(file_get_contents($logoPath));
}
?>

<div class="container">
    
    <div class="header-container">

        <?php if ($logoBase64): ?>
            <img src="<?= $logoBase64 ?>" class="logo-left" alt="Logo">
        <?php endif; ?>

        <div class="title-block">
            <h1>Laporan Data Barang Masuk</h1>
            <p>Periode: <?= date('d M Y') ?></p>
            <p>Dicetak oleh: <strong><?= htmlspecialchars($username) ?></strong></p>
        </div>

    </div>

    <table>
        <thead>
            <tr>
                <th>No</th>
                <th>Nama Pengirim</th>
                <th>Nama Vendor</th>
                <th>No Registrasi</th>
                <th>Jenis Barang</th>
                <th>Penerima</th>
                <th>Security</th>
                <th>Location</th>
                <th>Tanggal</th>
                <th>Waktu Masuk</th>
                <th>Foto</th>
            </tr>
        </thead>

        <tbody>
        <?php 
        $no=1; 
        foreach($barang_masuk as $b): ?>
            <tr>
                <td><?= $no++ ?></td>
                <td><?= htmlspecialchars($b->nama_pengirim) ?></td>
                <td><?= htmlspecialchars($b->nama_vendor) ?></td>
                <td><?= htmlspecialchars($b->no_registrasi) ?></td>
                <td><?= htmlspecialchars($b->jenis_barang) ?></td>
                <td><?= htmlspecialchars($b->penerima) ?></td>
                <td><?= htmlspecialchars($b->security) ?></td>
                <td><?= isset($b->location) ? htmlspecialchars($b->location) : '-' ?></td>
                <td><?= date('d/m/Y', strtotime($b->tanggal)) ?></td>
                <td><?= date('H:i', strtotime($b->waktu_masuk)) ?></td>
                <td class="foto">
                    <?php if (!empty($b->foto_data)): ?>
                        <img src="<?= $b->foto_data ?>" alt="Foto Barang">
                    <?php else: ?>
                        <em>Tidak ada</em>
                    <?php endif; ?>
                </td>
            </tr>
        <?php endforeach; ?>
        </tbody>
    </table>

    <div class="footer">
        <p><em>Akhir Laporan — Dicetak pada <?= date('d/m/Y H:i') ?></em></p>
    </div>

</div>

</body>
</html>
