<?php
// Set timezone ke WIB
date_default_timezone_set('Asia/Jakarta');

// Format Tanggal Hari Ini (Indonesia/WIB)
$date_format = date('l, d F Y');

// Tentukan ucapan sesuai jam
$hour = date('H'); 
$icon_class = 'fa-sun'; // Default icon

if ($hour >= 5 && $hour < 12) { 
    $greeting = "Good Morning";
    $icon_class = 'fa-cloud-sun'; // Pagi
} elseif ($hour >= 12 && $hour < 15) {
    $greeting = "Good Afternoon";
    $icon_class = 'fa-sun'; // Siang
} elseif ($hour >= 15 && $hour < 18) {
    $greeting = "Good Afternoon"; 
    $icon_class = 'fa-cloud-sun-rain'; // Sore
} else {
    $greeting = "Good Night";
    $icon_class = 'fa-moon'; // Malam
}

// Catatan: Variabel $username harus tersedia dari controller/session Anda. 
$username = isset($username) ? $username : $this->session->userdata('username');
?>

<!DOCTYPE html>
<html>
<head>
    <title>Security Dashboard</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <link rel="icon" href="<?= base_url('asset/img/asiaserv-logo.png') ?>" type="image/png">
    <style>
        /* BASE & BACKGROUND */
        body {
            background-image: url('<?= base_url("asset/img/log.jpg") ?>');
            background-size: cover;
            background-position: center;
            background-repeat: no-repeat;
            background-attachment: fixed;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            min-height: 100vh;
            padding-bottom: 80px; 
            position: relative;
        }
        
        /* NAVBAR */
        .navbar {
            border-bottom: 5px solid #ffbf00ff; /* Garis tegas kuning */
        }
        .navbar-brand .fw-bold {
            color: #1e3c72; /* Warna teks corporate */
        }

        /* HEADER CARD (Welcoming Section) */
        /* HEADER CARD - Gradien Atas ke Bawah */
.header-card {
    /* Menggunakan 'to bottom' = 180deg. Mulai dari Biru Muda/Putih ke Biru Tua */
    background: linear-gradient(to bottom, #ffffffff 0%, #333176 100%); 
    
    color: #ffffff; 
    padding: 35px 25px; /* Padding yang lebih rapi */
    border-radius: 18px !important; /* Sudut melengkung yang modern */
    margin: 40px auto 30px auto; 
    text-align: center;
    
    /* Bayangan yang lebih bersih */
    box-shadow: 0 12px 25px rgba(0, 0, 0, 0.35) !important; 
    
    max-width: 900px;
    position: relative;
    overflow: hidden;
    border: none;
    transition: transform 0.3s ease;
}

/* Tambahan: Efek hover sederhana */
.header-card:hover {
    transform: translateY(-3px);
}

        .header-card .logo-container {
            /* Menghapus background putih pada logo, agar transparan */
            background: none; 
            padding: 0;
            box-shadow: none;
            margin-bottom: 10px;
        }
        .header-card img {
            filter: drop-shadow(0 0 5px rgba(0, 0, 0, 0.5)); /* Efek bayangan pada logo */
        }
        .header-card h2 {
            font-size: 2.2rem;
            text-shadow: 0 2px 4px rgba(0, 0, 0, 0.5);
            margin-top: 10px;
        }
        .header-card .datetime-info {
            font-size: 1rem;
            font-weight: 400;
        }
        .header-card h2 i {
             animation: pulse 2s infinite;
        }

        /* MENU CARDS (Action Buttons) */
        .action-card {
            border-radius: 15px;
            border: 1px solid #dee2e6; /* Border tipis untuk kesan rapi */
            transition: all 0.3s ease;
            height: 100%;
            padding: 25px;
            text-align: center;
            box-shadow: 0 2px 8px rgba(0,0,0,0.1);
        }
        .action-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 8px 20px rgba(0, 0, 0, 0.2);
        }

        .action-card .icon-box {
            font-size: 4rem; /* Ikon lebih besar dan dominan */
            margin-bottom: 15px;
        }
        .action-card h5 {
            font-weight: 700;
            margin-bottom: 5px;
            color: #343a40;
        }
        .action-card p {
            font-size: 0.9rem;
            color: #6c757d;
            height: 40px; /* Menjaga tinggi agar tombol sejajar */
        }
        
        /* Button Styling */
        .btn-custom {
            border-radius: 25px;
            padding: 10px 20px;
            font-weight: bold;
            letter-spacing: 0.5px;
        }
        .btn-primary { background-color: #1e3c72; border-color: #1e3c72; }
        .btn-primary:hover { background-color: #2a5298; border-color: #2a5298; }
        
        /* Footer */
        footer {
            padding: 20px 0;
            background: #212529;
            color: #adb5bd;
            text-align: center;
            width: 100%;
            position: fixed; 
            bottom: 0;
            left: 0;
            z-index: 999;
        }

        /* Keyframes */
        @keyframes pulse {
             0% { transform: scale(1); }
             50% { transform: scale(1.05); }
             100% { transform: scale(1); }
        }
    </style>
</head>
<body>

<nav class="navbar navbar-light bg-white shadow-sm sticky-top">
    <div class="container-fluid d-flex justify-content-between align-items-center px-4"> 
        
        <a class="navbar-brand d-flex align-items-center p-0" href="#"> 
            <img src="<?= base_url('asset/img/logo-asiaserv.png') ?>" 
                alt="Logo" 
                height="100" 
                class="me-3">
            <span class="fw-bold fs-5 d-none d-sm-inline">Security Command Center</span>
        </a>
        
        <a href="<?= base_url('index.php/logout') ?>" class="btn btn-sm btn-danger shadow-sm btn-custom">
            <i class="fa fa-sign-out-alt me-1"></i> Logout
        </a>
    </div>
</nav>

<div class="container py-4">

<div class="card shadow-lg border-0 header-card mx-auto">
  <div class="card-body">
    <div class="logo-container"> 
      <img src="<?= base_url('asset/img/logo-asiaserv.png') ?>" alt="Logo" height="150">
    </div>
    
    <h2 class="fw-light mb-2">
      <i class="fa <?= $icon_class ?> me-3"></i><?= $greeting ?>, <span class="fw-bold"><?= $username ?></span>!
    </h2>
    
    <p class="datetime-info text-light">
      <i class="fa fa-calendar-alt me-2"></i> <?= $date_format ?> 
      <span class="mx-2">|</span> 
      <i class="fa fa-clock me-2"></i> <span id="current-time"></span> WIB 
    </p>

    <p class="mb-0 small fw-light">Your vigilance is appreciated. Ready for duty. 🛡️</p>
  </div>
</div>

<h4 class="text-center text-white mt-4 mb-4 fw-bold" style="text-shadow: 0 2px 4px rgba(0,0,0,0.5);">Main Operations</h4>
<div class="row g-4 justify-content-center">
    
    <div class="col-md-6 col-lg-4">
        <div class="card action-card">
            <div class="card-body">
                <div class="icon-box text-primary"><i class="fa fa-clipboard-list"></i></div>
                <h5 class="card-title">Guest Log</h5>
                <p class="text-muted">Register new guests and update exit status.</p>
                <a href="<?= base_url('index.php/tamu_user') ?>" class="btn btn-primary btn-custom w-100 shadow-sm">
                    <i class="fa fa-user-check me-1"></i> Guest Check-In/Out
                </a>
            </div>
        </div>
    </div>

    <div class="col-md-6 col-lg-4">
        <div class="card action-card">
            <div class="card-body">
                <div class="icon-box text-success"><i class="fa fa-box-open"></i></div>
                <h5 class="card-title">Incoming Goods</h5>
                <p class="text-muted">Record items being received today.</p>
                <a href="<?= site_url('barang_masuk_controller') ?>" class="btn btn-success btn-custom w-100 shadow-sm">
                    <i class="fa fa-plus me-1"></i> Record Incoming
                </a>
            </div>
        </div>
    </div>

    <div class="col-md-6 col-lg-4">
        <div class="card action-card">
            <div class="card-body">
                <div class="icon-box text-danger"><i class="fa fa-truck-loading"></i></div>
                <h5 class="card-title">Exit Item Log</h5>
                <p class="text-muted">Record items leaving the premises.</p>
                <a href="<?= site_url('barang_keluar_controller') ?>" class="btn btn-danger btn-custom w-100 shadow-sm">
                    <i class="fa fa-minus me-1"></i> Record Exit
                </a>
            </div>
        </div>
    </div>
</div>

</div> 

<footer>
    <small>© <?= date('Y') ?> Security Dashboard | AsiaServ Guard</small>
</footer>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script>
    function updateTime() {
        const now = new Date();
        
        // Format jam (HH:MM:SS)
        const hours = String(now.getHours()).padStart(2, '0');
        const minutes = String(now.getMinutes()).padStart(2, '0');
        const seconds = String(now.getSeconds()).padStart(2, '0');
        
        const timeString = `${hours}:${minutes}:${seconds}`;
        
        document.getElementById('current-time').textContent = timeString;
    }

    updateTime();
    setInterval(updateTime, 1000);
</script>

</body>
</html>